/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.system.opener;

import org.phoenicis.configuration.security.Safe;
import org.phoenicis.tools.system.OperatingSystemFetcher;
import org.phoenicis.tools.system.opener.Opener;

@Safe
public class AutomaticOpener
implements Opener {
    private final Opener delegatedOpener;

    public AutomaticOpener(Opener linuxOpener, Opener macOsOpener, OperatingSystemFetcher operatingSystemFetcher) {
        switch (operatingSystemFetcher.fetchCurrentOperationSystem()) {
            case LINUX: {
                this.delegatedOpener = linuxOpener;
                break;
            }
            case MACOSX: {
                this.delegatedOpener = macOsOpener;
                break;
            }
            default: {
                this.delegatedOpener = file -> {
                    throw new UnsupportedOperationException();
                };
            }
        }
    }

    @Override
    public void open(String file) {
        this.delegatedOpener.open(file);
    }
}

