/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.system;

import org.phoenicis.configuration.security.Safe;
import org.phoenicis.entities.Architecture;
import org.phoenicis.entities.OperatingSystem;
import org.phoenicis.tools.system.OperatingSystemFetcher;

@Safe
public class ArchitectureFetcher {
    private final OperatingSystemFetcher operatingSystemFetcher;

    public ArchitectureFetcher(OperatingSystemFetcher operatingSystemFetcher) {
        this.operatingSystemFetcher = operatingSystemFetcher;
    }

    public Architecture fetchCurrentArchitecture() {
        if (this.operatingSystemFetcher.fetchCurrentOperationSystem() == OperatingSystem.MACOSX) {
            return Architecture.AMD64;
        }
        if ("x86".equals(System.getProperty("os.arch")) || "i386".equals(System.getProperty("os.arch"))) {
            return Architecture.I386;
        }
        return Architecture.AMD64;
    }

    public Architecture fromWinePackageName(String architectureName) {
        switch (architectureName) {
            case "x86": {
                return Architecture.I386;
            }
            case "amd64": {
                return Architecture.AMD64;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown architecture '%s'", architectureName));
    }
}

