/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.stream;

import java.io.IOException;
import java.io.InputStream;

public class CursorFinderInputStream
extends InputStream {
    private final byte[] cursor;
    private final InputStream inputStream;
    private int cursorPosition = 0;
    private int readPosition = 0;

    public CursorFinderInputStream(InputStream inputStream, byte[] cursor) {
        this.inputStream = inputStream;
        this.cursor = cursor;
    }

    @Override
    public int read() throws IOException {
        while (true) {
            if (this.cursorHasBeenFound()) {
                if (!this.cursorHasBeenRead()) {
                    return this.cursor[this.readPosition++];
                }
                return this.inputStream.read();
            }
            int delegatedInputStreamValue = this.inputStream.read();
            if (delegatedInputStreamValue == -1) {
                return -1;
            }
            if (this.cursor[this.cursorPosition] == delegatedInputStreamValue) {
                ++this.cursorPosition;
                continue;
            }
            this.cursorPosition = 0;
        }
    }

    private boolean cursorHasBeenRead() {
        return this.readPosition >= this.cursor.length;
    }

    private boolean cursorHasBeenFound() {
        return this.cursorPosition >= this.cursor.length;
    }
}

