/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.processes;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.phoenicis.tools.processes.PhoenicisProcess;

public class PhoenicisProcessBuilder {
    private List<String> command;
    private String basePath;
    private Map<String, String> environment;
    private String outputPath;

    public PhoenicisProcessBuilder withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public PhoenicisProcessBuilder withBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public PhoenicisProcessBuilder withEnvironment(Map<String, String> environment) {
        this.environment = environment;
        return this;
    }

    public PhoenicisProcessBuilder withOutputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    public PhoenicisProcess start() throws IOException {
        if (this.command == null || this.command.isEmpty()) {
            throw new IllegalArgumentException("Command can't be null or empty");
        }
        if (this.basePath == null) {
            throw new IllegalArgumentException("Base path can't be null");
        }
        File directory = new File(this.basePath);
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Base path is either does not exist or is no directory");
        }
        if (this.environment == null) {
            this.environment = Map.of();
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.command).directory(directory).inheritIO();
        processBuilder.environment().putAll(this.environment);
        if (this.outputPath != null) {
            File output = new File(this.outputPath);
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectOutput(output);
        }
        Process process = processBuilder.start();
        return new PhoenicisProcess(process);
    }
}

