/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

class PhoenicisUrlConnection {
    private Integer responseCode;
    private HttpURLConnection delegateUrlConnection;
    private URL url;
    private Map<String, String> headers;

    private PhoenicisUrlConnection(HttpURLConnection urlConnection, URL url) {
        this.delegateUrlConnection = urlConnection;
        this.url = url;
        this.responseCode = null;
    }

    static PhoenicisUrlConnection fromURL(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        return new PhoenicisUrlConnection(connection, url);
    }

    void connect() throws IOException {
        this.followRedirectsAndGetResponseCode();
    }

    void disconnect() {
        this.delegateUrlConnection.disconnect();
    }

    long getLastModified() {
        return this.delegateUrlConnection.getLastModified();
    }

    InputStream getInputStream() throws IOException {
        return this.delegateUrlConnection.getInputStream();
    }

    long getContentLengthLong() {
        return this.delegateUrlConnection.getContentLengthLong();
    }

    String fetchFileName() throws IOException {
        int index;
        String disposition;
        int responseCode = this.getReponseCode();
        if (responseCode == 200 && (disposition = this.delegateUrlConnection.getHeaderField("Content-Disposition")) != null && (index = disposition.indexOf("filename=")) > 0) {
            return disposition.substring(index + 10, disposition.length() - 1);
        }
        return this.fetchFilenameFromUrl();
    }

    private int getReponseCode() throws IOException {
        return this.followRedirectsAndGetResponseCode();
    }

    private String fetchFilenameFromUrl() {
        return this.url.toExternalForm().substring(this.url.toExternalForm().lastIndexOf("/") + 1).split("\\?")[0];
    }

    private int followRedirectsAndGetResponseCode() throws IOException {
        if (this.responseCode == null) {
            this.responseCode = this.delegateUrlConnection.getResponseCode();
        }
        if (this.responseCode == 302 || this.responseCode == 301) {
            String redirectLocation = this.delegateUrlConnection.getHeaderField("Location");
            this.url = new URL(redirectLocation);
            this.delegateUrlConnection = (HttpURLConnection)this.url.openConnection();
            this.delegateUrlConnection.setInstanceFollowRedirects(false);
            this.responseCode = null;
            if (this.headers != null) {
                this.setHeaders(this.headers);
            }
            this.followRedirectsAndGetResponseCode();
        }
        return this.responseCode;
    }

    void setHeaders(Map<String, String> headers) {
        this.headers = headers;
        headers.forEach(this.delegateUrlConnection::setRequestProperty);
    }
}

