/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.function.Consumer;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.entities.ProgressEntity;
import org.phoenicis.entities.ProgressState;
import org.phoenicis.tools.files.FileSizeUtilities;
import org.phoenicis.tools.http.DownloadException;
import org.phoenicis.tools.http.PhoenicisUrlConnection;

@Safe
public class Downloader {
    private static final String EXCEPTION_ITEM_DOWNLOAD_FAILED = "Download of %s has failed";
    private static final int BLOCK_SIZE = 1024;
    private final FileSizeUtilities fileSizeUtilities;

    public Downloader(FileSizeUtilities fileSizeUtilities) {
        this.fileSizeUtilities = fileSizeUtilities;
    }

    public File get(String url, String localDestination, Consumer<ProgressEntity> onChange) {
        try {
            return this.get(new URL(url), new File(localDestination), onChange);
        }
        catch (MalformedURLException e) {
            throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
        }
    }

    public File get(String url, String localDestination, Map<String, String> headers, Consumer<ProgressEntity> onChange) {
        try {
            return this.get(new URL(url), new File(localDestination), headers, onChange);
        }
        catch (MalformedURLException e) {
            throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File get(URL url, File localDestination, Map<String, String> headers, Consumer<ProgressEntity> onChange) {
        File file;
        if (localDestination.isDirectory()) return this.getInsideDirectory(url, localDestination, headers, onChange);
        FileOutputStream fileOutputStream = new FileOutputStream(localDestination);
        try {
            this.get(url, fileOutputStream, onChange);
            file = localDestination;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
            }
        }
        fileOutputStream.close();
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File get(URL url, File localDestination, Consumer<ProgressEntity> onChange) {
        File file;
        if (localDestination.isDirectory()) return this.getInsideDirectory(url, localDestination, null, onChange);
        FileOutputStream fileOutputStream = new FileOutputStream(localDestination);
        try {
            this.get(url, fileOutputStream, onChange);
            file = localDestination;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
            }
        }
        fileOutputStream.close();
        return file;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private File getInsideDirectory(URL url, File directory, Map<String, String> headers, Consumer<ProgressEntity> onChange) {
        try {
            PhoenicisUrlConnection connection = PhoenicisUrlConnection.fromURL(url);
            if (headers != null) {
                connection.setHeaders(headers);
            }
            String fileName = connection.fetchFileName();
            File localFile = new File(directory, fileName);
            try {
                File file;
                try (FileOutputStream fileOutputStream = new FileOutputStream(localFile);){
                    this.saveConnectionToStream(url, connection, fileOutputStream, onChange);
                    file = new File(directory, fileName);
                }
                return file;
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
        }
    }

    public String get(String url, Consumer<ProgressEntity> onChange) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.get(new URL(url), outputStream, onChange);
        }
        catch (MalformedURLException e) {
            throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
        }
        return outputStream.toString();
    }

    public String get(String url, Map<String, String> headers, Consumer<ProgressEntity> onChange) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.get(new URL(url), outputStream, headers, onChange);
        }
        catch (MalformedURLException e) {
            throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
        }
        return outputStream.toString();
    }

    public String get(URL url, Consumer<ProgressEntity> onChange) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.get(url, outputStream, onChange);
        return outputStream.toString();
    }

    public byte[] getBytes(URL url, Consumer<ProgressEntity> onChange) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.get(url, outputStream, onChange);
        return outputStream.toByteArray();
    }

    private void get(URL url, OutputStream outputStream, Consumer<ProgressEntity> onChange) {
        this.get(url, outputStream, null, onChange);
    }

    private void get(URL url, OutputStream outputStream, Map<String, String> headers, Consumer<ProgressEntity> onChange) {
        try {
            PhoenicisUrlConnection connection = PhoenicisUrlConnection.fromURL(url);
            if (headers != null) {
                connection.setHeaders(headers);
            }
            connection.connect();
            this.saveConnectionToStream(url, connection, outputStream, onChange);
            connection.disconnect();
        }
        catch (IOException e) {
            throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
        }
    }

    private void saveConnectionToStream(URL url, PhoenicisUrlConnection connection, OutputStream outputStream, Consumer<ProgressEntity> onChange) {
        float percentage = 0.0f;
        this.changeState(ProgressState.READY, percentage, "", onChange);
        try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1024);){
            int i;
            long fileSize = connection.getContentLengthLong();
            byte[] data = new byte[1024];
            long totalDataRead = 0L;
            while ((i = inputStream.read(data, 0, 1024)) >= 0) {
                bufferedOutputStream.write(data, 0, i);
                percentage = (float)(totalDataRead += (long)i) * 100.0f / (float)fileSize;
                this.changeState(ProgressState.PROGRESSING, percentage, String.format("%s / %s downloaded", this.fileSizeUtilities.humanReadableByteCount(totalDataRead, false), this.fileSizeUtilities.humanReadableByteCount(fileSize, false)), onChange);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException("The download has been aborted");
            }
            outputStream.flush();
        }
        catch (IOException | InterruptedException e) {
            this.changeState(ProgressState.FAILED, percentage, "", onChange);
            throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
        }
        this.changeState(ProgressState.SUCCESS, percentage, "", onChange);
    }

    private void changeState(ProgressState state, float percentage, String progressText, Consumer<ProgressEntity> onChange) {
        if (onChange != null) {
            ProgressEntity currentState = new ProgressEntity.Builder().withPercent((double)percentage).withState(state).withProgressText(progressText).build();
            onChange.accept(currentState);
        }
    }

    public boolean isUpdateAvailable(String localFile, String url) {
        try {
            return this.isUpdateAvailable(new File(localFile), new URL(url));
        }
        catch (MalformedURLException e) {
            throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
        }
    }

    public boolean isUpdateAvailable(File localFile, URL url) {
        if (!localFile.exists()) {
            return true;
        }
        try {
            PhoenicisUrlConnection connection = PhoenicisUrlConnection.fromURL(url);
            connection.connect();
            long fileLastModified = localFile.lastModified();
            long urlLastModified = connection.getLastModified();
            connection.disconnect();
            if (fileLastModified == 0L || urlLastModified == 0L) {
                return true;
            }
            return fileLastModified <= urlLastModified;
        }
        catch (IOException e) {
            throw new DownloadException(String.format(EXCEPTION_ITEM_DOWNLOAD_FAILED, url), e);
        }
    }
}

