/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.gpg;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.phoenicis.tools.gpg.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureChecker {
    private final Logger LOGGER = LoggerFactory.getLogger(SignatureChecker.class);
    private String publicKey;
    private String signedData;
    private String signature;

    public SignatureChecker withSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public SignatureChecker withData(String signedData) {
        this.signedData = signedData;
        return this;
    }

    public SignatureChecker withPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public Boolean check() {
        ArmoredInputStream armoredInputStream;
        PGPPublicKey pgpSigningKey = this.readPublicKey(new ByteArrayInputStream(this.publicKey.getBytes()));
        try {
            armoredInputStream = new ArmoredInputStream((InputStream)new ByteArrayInputStream(this.signature.getBytes()));
        }
        catch (IOException e) {
            throw new SignatureException("Failed to verify signature", e);
        }
        PGPObjectFactory pgpObjectFactory = new PGPObjectFactory((InputStream)armoredInputStream);
        try {
            PGPSignatureList list;
            Object nextObject = pgpObjectFactory.nextObject();
            PGPSignature pgpSignature = null;
            if (nextObject instanceof PGPSignatureList && !(list = (PGPSignatureList)nextObject).isEmpty()) {
                pgpSignature = list.get(0);
            }
            if (pgpSignature == null) {
                return false;
            }
            this.initVerify(pgpSignature, pgpSigningKey);
            pgpSignature.update(this.signedData.getBytes());
            return pgpSignature.verify();
        }
        catch (IOException | NoSuchProviderException | java.security.SignatureException | PGPException e) {
            throw new SignatureException("Failed to verify signature", (Exception)e);
        }
    }

    private void initVerify(PGPSignature pgpSignature, PGPPublicKey pgpSigningKey) throws PGPException, NoSuchProviderException {
        try {
            pgpSignature.initVerify(pgpSigningKey, "BC");
        }
        catch (NoSuchProviderException e) {
            this.LOGGER.debug("No security provider found. Adding bouncy castle. This message can be ignored", (Throwable)e);
            Security.addProvider((Provider)new BouncyCastleProvider());
            pgpSignature.initVerify(pgpSigningKey, "BC");
        }
    }

    private PGPPublicKey readPublicKey(InputStream publicKeyInputStream) {
        PGPPublicKey pGPPublicKey;
        block11: {
            InputStream publicKeyDecoderStream = PGPUtil.getDecoderStream((InputStream)publicKeyInputStream);
            try {
                PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(publicKeyDecoderStream);
                PGPPublicKey key = null;
                Iterator rIt = pgpPub.getKeyRings();
                while (key == null && rIt.hasNext()) {
                    PGPPublicKeyRing kRing = (PGPPublicKeyRing)rIt.next();
                    Iterator kIt = kRing.getPublicKeys();
                    while (key == null && kIt.hasNext()) {
                        key = (PGPPublicKey)kIt.next();
                    }
                }
                if (key == null) {
                    throw new IllegalArgumentException("Can't find encryption key in key ring.");
                }
                pGPPublicKey = key;
                if (publicKeyDecoderStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (publicKeyDecoderStream != null) {
                        try {
                            publicKeyDecoderStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | PGPException e) {
                    throw new SignatureException("Failed to read public key", (Exception)e);
                }
            }
            publicKeyDecoderStream.close();
        }
        return pGPPublicKey;
    }

    public static String getPublicKey() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(SignatureChecker.class.getResourceAsStream("phoenicis.gpg")));
        StringBuilder readPublicKey = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                readPublicKey.append(line).append("\n");
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return readPublicKey.toString();
    }

    public String toString() {
        return new ToStringBuilder(SignatureChecker.class).append((Object)this.publicKey).append((Object)this.signedData).append((Object)this.signature).toString();
    }
}

