/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.files;

import java.io.File;
import org.phoenicis.configuration.security.Safe;
import org.springframework.beans.factory.annotation.Value;

@Safe
public class FilesManipulator {
    @Value(value="${application.user.root}")
    private String userRoot;

    private boolean isInSubDirectory(File directory, File fileIside) {
        return fileIside != null && (fileIside.equals(directory) || this.isInSubDirectory(directory, fileIside.getParentFile()));
    }

    protected boolean isInDirectory(File file) {
        return this.isInSubDirectory(new File(this.userRoot), file);
    }

    protected void assertInDirectory(File file) {
        if (!this.isInSubDirectory(new File(this.userRoot), file)) {
            throw new IllegalArgumentException(String.format("The file (%s) must be in the Phoenicis root directory (%s)", file, this.userRoot));
        }
    }
}

