/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.tools.files.FilesManipulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class FileSearcher
extends FilesManipulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSearcher.class);

    public List<File> search(String directory, String name) {
        return this.search(new File(directory), name);
    }

    public List<File> search(File directory, final String name) {
        this.assertInDirectory(directory);
        if (!directory.exists()) {
            return Collections.emptyList();
        }
        final ArrayList<File> results = new ArrayList<File>();
        Path startPath = Paths.get(directory.getAbsolutePath(), new String[0]);
        try {
            Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (name.equalsIgnoreCase(file.getFileName().toString())) {
                        results.add(file.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException e) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.warn("Cannot search into directory: " + directory, (Throwable)e);
            return Collections.emptyList();
        }
        return results;
    }
}

