/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Consumer;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.entities.ProgressEntity;

@Safe
public class FileCopier {
    private static final int BLOCK_SIZE = 1024;

    public void copyFile(File sourceFile, File destinationFile, Consumer<ProgressEntity> onChange) throws IOException, InterruptedException {
        int fileSize = (int)sourceFile.length();
        float totalDataRead = 0.0f;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(sourceFile));
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile), 1024);){
            int i;
            byte[] data = new byte[1024];
            while ((i = inputStream.read(data, 0, 1024)) >= 0) {
                outputStream.write(data, 0, i);
                int percentCopied = (int)((totalDataRead += (float)i) * 100.0f / (float)fileSize);
                onChange.accept(new ProgressEntity.Builder().withPercent((double)percentCopied).build());
                if (!Thread.interrupted()) continue;
                throw new InterruptedException("The copy process was interrupted");
            }
            inputStream.close();
            outputStream.close();
        }
    }
}

