/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.activation.MimetypesFileTypeMap;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicException;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import net.sf.jmimemagic.MagicParseException;
import org.apache.commons.io.FileUtils;
import org.phoenicis.configuration.security.Safe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class FileAnalyser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAnalyser.class);

    public static String identifyLineDelimiter(String fileContent) {
        if (fileContent.matches("(?s).*(\\r\\n).*")) {
            return "\r\n";
        }
        if (fileContent.matches("(?s).*(\\n).*")) {
            return "\n";
        }
        if (fileContent.matches("(?s).*(\\r).*")) {
            return "\r";
        }
        return "\n";
    }

    public static String identifyLineDelimiter(File fileToAnalyse) throws IOException {
        String fileContent = FileUtils.readFileToString((File)fileToAnalyse);
        return FileAnalyser.identifyLineDelimiter(fileContent);
    }

    private MagicMatch getMatch(File inputFile) throws MagicMatchNotFoundException {
        Path path = Paths.get(inputFile.getAbsolutePath(), new String[0]);
        try {
            byte[] data = Files.readAllBytes(path);
            return Magic.getMagicMatch((byte[])data, (boolean)true);
        }
        catch (IOException | MagicException | MagicParseException e) {
            throw new IllegalStateException("Unable to detect mimetype of the file", e);
        }
    }

    public String getDescription(File inputFile) {
        try {
            return this.getMatch(inputFile).getDescription();
        }
        catch (MagicMatchNotFoundException e) {
            throw new IllegalStateException("Unable to detect mimetype of the file", e);
        }
    }

    public String getMimetype(File inputFile) {
        try {
            MagicMatch match = this.getMatch(inputFile);
            String mimeType = match.getMimeType();
            if ("???".equals(mimeType)) {
                return this.guessMimeTypeFromDescription(match);
            }
            return mimeType;
        }
        catch (MagicMatchNotFoundException e) {
            LOGGER.debug("Failed to get Mime Type", (Throwable)e);
            MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
            return mimeTypesMap.getContentType(inputFile);
        }
    }

    private String guessMimeTypeFromDescription(MagicMatch match) {
        if ("MS-DOS executable (EXE)".equals(match.getDescription())) {
            return "application/x-dosexec";
        }
        return "???";
    }
}

