/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.files;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.tools.files.DirectoryWatcher;

@Safe
public class DirectoryWatcherFiles
extends DirectoryWatcher<List<File>> {
    public DirectoryWatcherFiles(ExecutorService executorService, Path observedDirectory) {
        super(executorService, observedDirectory);
    }

    @Override
    protected List<File> defineWatchedObject() {
        File[] files = this.observedDirectory.toFile().listFiles();
        assert (files != null);
        return Arrays.stream(files).filter(f -> !f.getName().startsWith(".")).collect(Collectors.toList());
    }
}

