/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.files;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.commons.lang.builder.ToStringBuilder;

abstract class DirectoryWatcher<T>
implements AutoCloseable {
    protected final Path observedDirectory;
    private final WatchService watcher;
    private Consumer<T> changeConsumer;

    DirectoryWatcher(ExecutorService executorService, Path observedDirectory) {
        try {
            DirectoryWatcher.validate(observedDirectory);
            this.observedDirectory = observedDirectory;
            this.watcher = FileSystems.getDefault().newWatchService();
            observedDirectory.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            executorService.submit(this::run);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to create watcher for %s", observedDirectory.toString()));
        }
    }

    private static void validate(Path observedDirectory) {
        if (!observedDirectory.toFile().isDirectory()) {
            throw new IllegalStateException(String.format("The file %s is not a valid directory", observedDirectory.toString()));
        }
    }

    protected abstract T defineWatchedObject();

    public void run() {
        try {
            WatchKey key = this.watcher.take();
            key.pollEvents();
            this.notifyConsumer();
            while (key.reset()) {
                key = this.watcher.take();
                key.pollEvents();
                this.notifyConsumer();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(String.format("Watcher Interupted for %s", this.observedDirectory.toString()));
        }
    }

    private void notifyConsumer() {
        if (this.changeConsumer != null) {
            this.changeConsumer.accept(this.defineWatchedObject());
        }
    }

    @Override
    public void close() {
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to close watcher for %s", this.observedDirectory.toString()));
        }
    }

    public Path getObservedDirectory() {
        return this.observedDirectory;
    }

    public void setOnChange(Consumer<T> changeConsumer) {
        this.changeConsumer = changeConsumer;
        this.notifyConsumer();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.observedDirectory.getFileName()).toString();
    }
}

