/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.config;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.tools.config.ConfigFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class CompatibleConfigFileFormat
implements ConfigFile {
    private final Logger LOGGER = LoggerFactory.getLogger(CompatibleConfigFileFormat.class);
    private final File configFile;
    private final ObjectMapper mapper;

    public CompatibleConfigFileFormat(ObjectMapper objectMapper, File configFile) {
        this.configFile = configFile;
        this.mapper = objectMapper;
    }

    @Override
    public synchronized void writeValue(String key, String value) throws IOException {
        Map<String, String> values = this.getMap();
        values.put(key, value);
        this.mapper.writeValue(this.configFile, values);
    }

    @Override
    public String readValue(String key) {
        return this.readValue(key, "");
    }

    @Override
    public boolean contains(String key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public synchronized String readValue(String key, String defaultValue) {
        String value = this.getMap().get(key);
        return value != null ? value : defaultValue;
    }

    private Map<String, String> getMap() {
        try {
            HashMap<String, String> results = new HashMap<String, String>();
            Map tmpResults = (Map)this.mapper.readValue(this.configFile, Map.class);
            for (Map.Entry entry : tmpResults.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                results.put((String)entry.getKey(), (String)entry.getValue());
            }
            return results;
        }
        catch (JsonParseException | JsonMappingException e) {
            this.LOGGER.debug("The file does not seems to be a JSON format. Trying legacy Phoenicis config file.", e);
            return this.getLegacyMap();
        }
        catch (IOException e) {
            this.LOGGER.debug(String.format("Couldn't read the config file %s. Will assume that the config file is empty. This can happen e.g. if a new container is just being created.", this.configFile.getAbsolutePath()));
            return new HashMap<String, String>();
        }
    }

    private Map<String, String> getLegacyMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.configFile));){
            String line = bufferedReader.readLine();
            while (line != null) {
                String[] splitLine = line.split("=");
                String newKey = splitLine[0];
                StringBuilder newValueBuilder = new StringBuilder();
                for (int i = 1; i < splitLine.length; ++i) {
                    if (i != 1) {
                        newValueBuilder.append('=');
                    }
                    newValueBuilder.append(splitLine[i]);
                }
                String newValue = newValueBuilder.toString();
                result.put(newKey, newValue);
                line = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            this.LOGGER.warn("IOException while reading the config file. Assuming default value", (Throwable)e);
        }
        return result;
    }

    @Override
    public synchronized void deleteValue(String key) throws IOException {
        Map<String, String> values = this.getMap();
        values.remove(key);
        this.mapper.writeValue(this.configFile, values);
    }
}

