/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.checksum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Consumer;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.entities.ProgressEntity;

@Safe
public class ChecksumCalculator {
    private static final int BLOCK_SIZE = 2048;
    private static final String WAIT_MESSAGE = (String)Localisation.tr((Object)"Verifying the file...");

    public String calculate(String fileToCheck, String algorithm, Consumer<ProgressEntity> onChange) throws IOException {
        return this.calculate(new File(fileToCheck), algorithm, onChange);
    }

    public String calculate(File fileToCheck, String algorithm, Consumer<ProgressEntity> onChange) throws IOException {
        long fileSize = FileUtils.sizeOf((File)fileToCheck);
        try (FileInputStream inputStream = new FileInputStream(fileToCheck);){
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
            byte[] digest = this.getDigest(inputStream, messageDigest, fileSize, onChange);
            String string = Hex.encodeHexString((byte[])digest);
            return string;
        }
    }

    private byte[] getDigest(InputStream inputStream, MessageDigest messageDigest, long sizeInBytes, Consumer<ProgressEntity> onChange) throws IOException {
        int numBytes;
        messageDigest.reset();
        byte[] bytes = new byte[2048];
        int readBytes = 0;
        while ((numBytes = inputStream.read(bytes)) != -1) {
            messageDigest.update(bytes, 0, numBytes);
            readBytes += numBytes;
            if (sizeInBytes == 0L) continue;
            double percentage = (double)readBytes * 100.0 / (double)sizeInBytes;
            this.changeState(percentage, onChange);
        }
        return messageDigest.digest();
    }

    private void changeState(double percentage, Consumer<ProgressEntity> onChange) {
        if (onChange != null) {
            onChange.accept(new ProgressEntity.Builder().withPercent(percentage).withProgressText(WAIT_MESSAGE).build());
        }
    }
}

