/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.archive.cab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.phoenicis.tools.archive.cab.CFData;
import org.phoenicis.tools.archive.cab.CFFile;
import org.phoenicis.tools.archive.cab.CFFolder;
import org.phoenicis.tools.archive.cab.CFHeader;
import org.phoenicis.tools.archive.cab.CabException;
import org.phoenicis.tools.archive.cab.CompressionType;

public class Cabfile {
    private final InputStream archiveStream;
    private long readBytes = 0L;

    public Cabfile(File archiveFile) {
        try {
            this.archiveStream = new FileInputStream(archiveFile);
        }
        catch (FileNotFoundException e) {
            throw new CabException(String.format("The file %s is not found", archiveFile), e);
        }
    }

    private int findCabOffset() {
        try {
            int i = 0;
            int successBytes = 0;
            while (true) {
                byte[] nextRead;
                int numRead;
                if ((numRead = this.archiveStream.read(nextRead = new byte[1])) == -1) {
                    throw new CabException("This file does not contain any cabinet archive");
                }
                if ((nextRead[0] & 0xFF) == 77 && successBytes == 0) {
                    ++successBytes;
                } else if ((nextRead[0] & 0xFF) == 83 && successBytes == 1) {
                    ++successBytes;
                } else if ((nextRead[0] & 0xFF) == 67 && successBytes == 2) {
                    ++successBytes;
                } else if ((nextRead[0] & 0xFF) == 70 && successBytes == 3) {
                    ++successBytes;
                } else if ((nextRead[0] & 0xFF) == 0 && successBytes == 4) {
                    ++successBytes;
                } else if ((nextRead[0] & 0xFF) == 0 && successBytes == 5) {
                    ++successBytes;
                } else if ((nextRead[0] & 0xFF) == 0 && successBytes == 6) {
                    ++successBytes;
                } else {
                    if ((nextRead[0] & 0xFF) == 0 && successBytes == 7) {
                        return i - 7;
                    }
                    successBytes = 0;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new CabException("Unable to find cab header", e);
        }
    }

    private CFHeader getHeader() {
        CFHeader cfHeader = new CFHeader(this.readBytes);
        cfHeader.populate(this.archiveStream);
        this.readBytes += (long)cfHeader.getStructureSize();
        return cfHeader;
    }

    public CFFolder getFolder() {
        CFFolder cfFolder = new CFFolder(this.readBytes);
        cfFolder.populate(this.archiveStream);
        this.readBytes += (long)cfFolder.getStructureSize();
        return cfFolder;
    }

    public CFFile getFile() {
        CFFile cfFile = new CFFile(this.readBytes);
        cfFile.populate(this.archiveStream);
        this.readBytes += (long)cfFile.getStructureSize();
        return cfFile;
    }

    public CFData getData(CompressionType compressionType) {
        CFData cfData = new CFData(this.readBytes, compressionType);
        cfData.populate(this.archiveStream);
        this.readBytes += (long)cfData.getStructureSize();
        return cfData;
    }

    private void skipBytes(long numberToSkip) throws IOException {
        this.readBytes += numberToSkip;
        this.archiveStream.skip(numberToSkip);
    }

    private void jumpTo(long offset) throws IOException {
        this.skipBytes(offset - this.readBytes);
    }
}

