/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.archive.cab;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.phoenicis.tools.archive.cab.AbstractCabStructure;
import org.phoenicis.tools.archive.cab.CabException;

public class CFHeader
extends AbstractCabStructure {
    byte[] signature = new byte[]{77, 83, 67, 70};
    byte[] reserved1 = new byte[]{0, 0, 0, 0};
    byte[] cbCabinet = new byte[4];
    byte[] reserved2 = new byte[4];
    byte[] coffFiles = new byte[4];
    byte[] reserved3 = new byte[4];
    byte[] versionMinor = new byte[1];
    byte[] versionMajor = new byte[1];
    byte[] cFolders = new byte[2];
    byte[] cFiles = new byte[2];
    byte[] flags = new byte[2];
    byte[] setID = new byte[2];
    byte[] iCabinet = new byte[2];
    byte[] cbCFHeader = new byte[2];
    byte[] cbCFFolder = new byte[1];
    byte[] cbCFData = new byte[1];
    byte[] abReserve = new byte[255];
    byte[] szCabinetPrev = new byte[255];
    byte[] szDiskPrev = new byte[255];
    byte[] szCabinetNext = new byte[255];
    byte[] szDiskNext = new byte[255];

    CFHeader(long offset) {
        super(offset);
    }

    @Override
    public void populate(InputStream inputStream) {
        try {
            this.structureSize += 8;
            this.structureSize += inputStream.read(this.cbCabinet);
            this.structureSize += inputStream.read(this.reserved2);
            this.structureSize += inputStream.read(this.coffFiles);
            this.structureSize += inputStream.read(this.reserved3);
            this.structureSize += inputStream.read(this.versionMinor);
            this.structureSize += inputStream.read(this.versionMajor);
            this.structureSize += inputStream.read(this.cFolders);
            this.structureSize += inputStream.read(this.cFiles);
            this.structureSize += inputStream.read(this.flags);
            this.structureSize += inputStream.read(this.setID);
            this.structureSize += inputStream.read(this.iCabinet);
        }
        catch (IOException e) {
            throw new CabException("Unable to parse header", e);
        }
    }

    public int getNumberOfFiles() {
        return (this.cFiles[0] & 0xFF) + (this.cFiles[1] & 0xFF) * 16;
    }

    public int getNumberOfFolders() {
        return (this.cFolders[0] & 0xFF) + (this.cFolders[1] & 0xFF) * 16;
    }

    public String toString() {
        return String.format("Offset: %s\nSize: %s\nSignature: %s\nReserved1: %s\ncbCabinet: %s\nReserved2: %s\ncoffFiles: %s\nReserved3: %s\nVersionMinor: %s\nVersionMajor: %s\ncFolders: %s\ncFiles: %s\ncbCFData: %s\ncbCFFolder: %s", this.offset, this.getStructureSize(), Arrays.toString(this.signature), Arrays.toString(this.reserved1), Arrays.toString(this.cbCabinet), Arrays.toString(this.reserved2), Arrays.toString(this.coffFiles), Arrays.toString(this.reserved3), this.versionMinor[0], this.versionMajor[0], Arrays.toString(this.cFolders), Arrays.toString(this.cFiles), this.cbCFData[0], this.cbCFFolder[0]);
    }
}

