/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.archive.cab;

import java.io.IOException;
import java.io.InputStream;
import org.phoenicis.tools.archive.cab.AbstractCabStructure;
import org.phoenicis.tools.archive.cab.CabException;
import org.phoenicis.tools.archive.cab.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFFolder
extends AbstractCabStructure {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractCabStructure.class);
    byte[] coffCabStart = new byte[4];
    byte[] cCFData = new byte[2];
    byte[] typeCompress = new byte[2];
    byte[] abReserve = new byte[256];

    CFFolder(long offset) {
        super(offset);
    }

    @Override
    public void populate(InputStream inputStream) {
        try {
            this.structureSize += inputStream.read(this.coffCabStart);
            this.structureSize += inputStream.read(this.cCFData);
            this.structureSize += inputStream.read(this.typeCompress);
        }
        catch (IOException e) {
            throw new CabException("Unable to extract CFFolder", e);
        }
    }

    public long getOffsetStartData() {
        return this.decodeLittleEndian(this.coffCabStart);
    }

    public long getNumberOfDataStructures() {
        return this.decodeLittleEndian(this.cCFData);
    }

    public CompressionType getCompressType() {
        Long compressType = this.decodeLittleEndian(this.typeCompress) & 0xFL;
        if (compressType == 0L) {
            return CompressionType.NONE;
        }
        if (compressType == 1L) {
            return CompressionType.MSZIP;
        }
        if (compressType == 2L) {
            return CompressionType.QUANTUM;
        }
        if (compressType == 3L) {
            return CompressionType.LZX;
        }
        throw new CabException("Unsupported compression type");
    }

    public String toString() {
        String compressType;
        try {
            compressType = this.getCompressType().name();
        }
        catch (CabException e) {
            this.LOGGER.warn("Failed to find compress type", (Throwable)e);
            compressType = "Unknown";
        }
        return String.format("Offset: %s\nSize: %s\nOffset of the first data: %s\nNumber of data structures: %s\ntypeCompress: %s\n", this.offset, this.getStructureSize(), this.getOffsetStartData(), this.getNumberOfDataStructures(), compressType);
    }
}

