/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.archive.cab;

import java.io.IOException;
import java.io.InputStream;
import org.phoenicis.tools.archive.cab.AbstractCabStructure;
import org.phoenicis.tools.archive.cab.CabException;

public class CFFile
extends AbstractCabStructure {
    byte[] cbFile = new byte[4];
    byte[] uoffFolderStart = new byte[4];
    byte[] iFolder = new byte[2];
    byte[] date = new byte[2];
    byte[] time = new byte[2];
    byte[] attribs = new byte[2];
    byte[] szName = new byte[257];

    CFFile(long offset) {
        super(offset);
    }

    @Override
    public void populate(InputStream inputStream) {
        try {
            this.structureSize += inputStream.read(this.cbFile);
            this.structureSize += inputStream.read(this.uoffFolderStart);
            this.structureSize += inputStream.read(this.iFolder);
            this.structureSize += inputStream.read(this.date);
            this.structureSize += inputStream.read(this.time);
            this.structureSize += inputStream.read(this.attribs);
            this.structureSize += this.readVariableField(inputStream, this.szName);
        }
        catch (IOException e) {
            throw new CabException("Unable to extract CFFolder", e);
        }
    }

    public long getUncompressedSize() {
        return this.decodeLittleEndian(this.cbFile);
    }

    public long getOffsetStartDataInsideFolder() {
        return this.decodeLittleEndian(this.uoffFolderStart);
    }

    public long getFolderIndex() {
        return this.decodeLittleEndian(this.iFolder);
    }

    public String toString() {
        return String.format("Offset: %s\nSize: %s\nUncompressed size: %s\nData offset: %s\nFolder: %s\nszName: %s\n", this.offset, this.getStructureSize(), this.getUncompressedSize(), this.getOffsetStartDataInsideFolder(), this.getFolderIndex(), this.getFilename());
    }

    public String getFilename() {
        return new String(this.szName).split("\u0000")[0];
    }
}

