/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.archive.cab;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.phoenicis.tools.archive.cab.AbstractCabStructure;
import org.phoenicis.tools.archive.cab.CabException;
import org.phoenicis.tools.archive.cab.CompressionType;

public class CFData
extends AbstractCabStructure {
    private final CompressionType compressionType;
    byte[] csum = new byte[4];
    byte[] cbData = new byte[2];
    byte[] cbUncomp = new byte[2];
    byte[] abReserve = new byte[256];
    byte[] ab;

    CFData(long offset, CompressionType compressionType) {
        super(offset);
        this.compressionType = compressionType;
    }

    @Override
    public void populate(InputStream inputStream) {
        try {
            this.structureSize += inputStream.read(this.csum);
            this.structureSize += inputStream.read(this.cbData);
            this.structureSize += inputStream.read(this.cbUncomp);
            this.ab = new byte[(int)this.getCompressedSize()];
            this.structureSize += inputStream.read(this.ab);
        }
        catch (IOException e) {
            throw new CabException("Unable to extract CFFolder", e);
        }
    }

    public String toString() {
        return String.format("Checksum: %s\nOffset: %s\nCompressed size: %s\nUncompressed size: %s\n", Arrays.toString(this.csum), this.offset, this.getCompressedSize(), this.getUncompressedSize());
    }

    public long getCompressedSize() {
        return this.decodeLittleEndian(this.cbData);
    }

    public long getUncompressedSize() {
        return this.decodeLittleEndian(this.cbUncomp);
    }
}

