/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.archive.cab;

import java.io.IOException;
import java.io.InputStream;
import org.phoenicis.tools.archive.cab.CabException;

abstract class AbstractCabStructure {
    protected final long offset;
    protected int structureSize;

    AbstractCabStructure(long offset) {
        this.offset = offset;
    }

    public abstract void populate(InputStream var1);

    protected int readVariableField(InputStream inputStream, byte[] results) {
        byte[] nextByte;
        int i = 0;
        do {
            int nbReadbytes;
            nextByte = new byte[1];
            try {
                nbReadbytes = inputStream.read(nextByte);
            }
            catch (IOException e) {
                throw new CabException("Unable to read input stream", e);
            }
            if (nbReadbytes == -1) {
                throw new CabException("This archive seems to be corrupted");
            }
            assert (1 == nbReadbytes);
            results[i] = nextByte[0];
            ++i;
        } while (nextByte[0] != 0);
        return i;
    }

    protected long decodeLittleEndian(byte[] bytes) {
        if (bytes.length == 4) {
            return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
        }
        return (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
    }

    public int getStructureSize() {
        return this.structureSize;
    }
}

