/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.entities.ProgressEntity;
import org.phoenicis.tools.archive.ArchiveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class Zip {
    private static final String ZIP_ERROR_MESSAGE = "Unable to open input stream";
    private final Logger LOGGER = LoggerFactory.getLogger(Zip.class);

    public List<File> uncompressZipFile(File inputFile, File outputDir, Consumer<ProgressEntity> stateCallback) {
        List<File> list;
        this.LOGGER.info(String.format("Attempting to unzip file \"%s\" to directory \"%s\".", inputFile.getAbsolutePath(), outputDir.getAbsolutePath()));
        Path targetDirPath = outputDir.toPath();
        ZipFile zipFile = new ZipFile(inputFile);
        try {
            long finalSize = FileUtils.sizeOf((File)inputFile);
            AtomicLong extractedBytesCounter = new AtomicLong(0L);
            Consumer<ZipExtractionResult> unzipCallback = zipExtractionResult -> {
                double currentExtractedBytes = extractedBytesCounter.addAndGet(zipExtractionResult.getExtractedBytes());
                stateCallback.accept(new ProgressEntity.Builder().withPercent(currentExtractedBytes / (double)finalSize * 100.0).withProgressText(Localisation.tr((String)"Extracted {0}", (Object)zipExtractionResult.getFileName())).build());
            };
            list = Collections.list(zipFile.getEntries()).stream().map(entry -> this.unzipEntry(zipFile, (ZipArchiveEntry)entry, targetDirPath, unzipCallback)).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ArchiveException(ZIP_ERROR_MESSAGE, e);
            }
        }
        zipFile.close();
        return list;
    }

    private File unzipEntry(ZipFile zipFile, ZipArchiveEntry entry, Path targetDirectory, Consumer<ZipExtractionResult> unzipCallback) {
        String fileName = entry.getName();
        long compressedSize = entry.getCompressedSize();
        Path targetPath = targetDirectory.resolve(fileName);
        if (!targetPath.normalize().startsWith(targetDirectory.normalize())) {
            throw new RuntimeException("Bad zip entry");
        }
        try {
            if (entry.isDirectory()) {
                this.LOGGER.info(String.format("Attempting to create output directory %s.", targetPath.toString()));
                Files.createDirectories(targetPath, new FileAttribute[0]);
            } else {
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                try (InputStream in = zipFile.getInputStream(entry);){
                    this.LOGGER.info(String.format("Creating output file %s.", targetPath.toString()));
                    Files.copy(in, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    unzipCallback.accept(new ZipExtractionResult(compressedSize, fileName));
                }
            }
            return targetPath.toFile();
        }
        catch (IOException e) {
            throw new ArchiveException(String.format("Unable to extract file \"%s\"", fileName), e);
        }
    }

    private static class ZipExtractionResult {
        private final long extractedBytes;
        private final String fileName;

        private ZipExtractionResult(long extractedBytes, String fileName) {
            this.extractedBytes = extractedBytes;
            this.fileName = fileName;
        }

        private long getExtractedBytes() {
            return this.extractedBytes;
        }

        private String getFileName() {
            return this.fileName;
        }
    }
}

