/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.archive;

import com.google.common.io.CountingInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.entities.ProgressEntity;
import org.phoenicis.tools.archive.ArchiveException;
import org.phoenicis.tools.files.FileUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class Tar {
    private static final String TAR_ERROR_MESSAGE = "Unable to open input stream";
    private final Logger LOGGER = LoggerFactory.getLogger(Tar.class);
    private final FileUtilities fileUtilities;

    public Tar(FileUtilities fileUtilities) {
        this.fileUtilities = fileUtilities;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    List<File> uncompressTarBz2File(File inputFile, File outputDir, Consumer<ProgressEntity> stateCallback) {
        try (CountingInputStream countingInputStream = new CountingInputStream((InputStream)new FileInputStream(inputFile));){
            List<File> list;
            try (BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream((InputStream)countingInputStream);){
                long finalSize = FileUtils.sizeOf((File)inputFile);
                list = this.uncompress((InputStream)inputStream, countingInputStream, outputDir, finalSize, stateCallback);
            }
            return list;
        }
        catch (IOException e) {
            throw new ArchiveException(TAR_ERROR_MESSAGE, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    List<File> uncompressTarGzFile(File inputFile, File outputDir, Consumer<ProgressEntity> stateCallback) {
        try (CountingInputStream countingInputStream = new CountingInputStream((InputStream)new FileInputStream(inputFile));){
            List<File> list;
            try (GZIPInputStream inputStream = new GZIPInputStream((InputStream)countingInputStream);){
                long finalSize = FileUtils.sizeOf((File)inputFile);
                list = this.uncompress(inputStream, countingInputStream, outputDir, finalSize, stateCallback);
            }
            return list;
        }
        catch (IOException e) {
            throw new ArchiveException(TAR_ERROR_MESSAGE, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    List<File> uncompressTarXzFile(File inputFile, File outputDir, Consumer<ProgressEntity> stateCallback) {
        try (CountingInputStream countingInputStream = new CountingInputStream((InputStream)new FileInputStream(inputFile));){
            List<File> list;
            try (XZCompressorInputStream inputStream = new XZCompressorInputStream((InputStream)countingInputStream);){
                long finalSize = FileUtils.sizeOf((File)inputFile);
                list = this.uncompress((InputStream)inputStream, countingInputStream, outputDir, finalSize, stateCallback);
            }
            return list;
        }
        catch (IOException e) {
            throw new ArchiveException(TAR_ERROR_MESSAGE, e);
        }
    }

    List<File> uncompressTarFile(File inputFile, File outputDir, Consumer<ProgressEntity> stateCallback) {
        List<File> list;
        CountingInputStream countingInputStream = new CountingInputStream((InputStream)new FileInputStream(inputFile));
        try {
            long finalSize = FileUtils.sizeOf((File)inputFile);
            list = this.uncompress((InputStream)countingInputStream, countingInputStream, outputDir, finalSize, stateCallback);
        }
        catch (Throwable throwable) {
            try {
                try {
                    countingInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ArchiveException(TAR_ERROR_MESSAGE, e);
            }
        }
        countingInputStream.close();
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public File gunzip(File inputFile, File outputFile) {
        this.LOGGER.info(String.format("Ungzipping %s to dir %s.", inputFile.getAbsolutePath(), outputFile.getAbsolutePath()));
        try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(inputFile));){
            File file;
            try (FileOutputStream out = new FileOutputStream(outputFile);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
                file = outputFile;
            }
            return file;
        }
        catch (IOException e) {
            throw new ArchiveException("Unable to gunzip file", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public File bunzip2(File inputFile, File outputFile) {
        this.LOGGER.info(String.format("Ungzipping %s to dir %s.", inputFile.getAbsolutePath(), outputFile.getAbsolutePath()));
        try (BZip2CompressorInputStream in = new BZip2CompressorInputStream((InputStream)new FileInputStream(inputFile));){
            File file;
            try (FileOutputStream out = new FileOutputStream(outputFile);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
                file = outputFile;
            }
            return file;
        }
        catch (IOException e) {
            throw new ArchiveException("Unable to gunzip file", e);
        }
    }

    private List<File> uncompress(InputStream inputStream, CountingInputStream countingInputStream, File outputDir, long finalSize, Consumer<ProgressEntity> stateCallback) {
        LinkedList<File> linkedList;
        block20: {
            LinkedList<File> uncompressedFiles = new LinkedList<File>();
            ArchiveInputStream debInputStream = new ArchiveStreamFactory().createArchiveInputStream("tar", inputStream);
            try {
                TarArchiveEntry entry;
                while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                    File outputFile = new File(outputDir, entry.getName());
                    if (entry.isDirectory()) {
                        this.LOGGER.info(String.format("Attempting to write output directory %s.", outputFile.getAbsolutePath()));
                        if (!outputFile.exists()) {
                            this.LOGGER.info(String.format("Attempting to createPrefix output directory %s.", outputFile.getAbsolutePath()));
                            Files.createDirectories(outputFile.toPath(), new FileAttribute[0]);
                        }
                    } else {
                        this.LOGGER.info(String.format("Creating output file %s (%s).", outputFile.getAbsolutePath(), entry.getMode()));
                        if (entry.isSymbolicLink()) {
                            Files.createSymbolicLink(Paths.get(outputFile.getAbsolutePath(), new String[0]), Paths.get(entry.getLinkName(), new String[0]), new FileAttribute[0]);
                        } else {
                            try (FileOutputStream outputFileStream = new FileOutputStream(outputFile);){
                                IOUtils.copy((InputStream)debInputStream, (OutputStream)outputFileStream);
                                Files.setPosixFilePermissions(Paths.get(outputFile.getPath(), new String[0]), this.fileUtilities.octToPosixFilePermission(entry.getMode()));
                            }
                        }
                    }
                    uncompressedFiles.add(outputFile);
                    stateCallback.accept(new ProgressEntity.Builder().withPercent((double)countingInputStream.getCount() / (double)finalSize * 100.0).withProgressText("Extracting " + outputFile.getName()).build());
                }
                linkedList = uncompressedFiles;
                if (debInputStream == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (debInputStream != null) {
                        try {
                            debInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | org.apache.commons.compress.archivers.ArchiveException e) {
                    throw new ArchiveException("Unable to extract the file", e);
                }
            }
            debInputStream.close();
        }
        return linkedList;
    }
}

