/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.archive;

import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.entities.ProgressEntity;
import org.phoenicis.tools.archive.Tar;
import org.phoenicis.tools.archive.Zip;
import org.phoenicis.tools.files.FileAnalyser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class Extractor {
    private final Logger LOGGER = LoggerFactory.getLogger(Tar.class);
    private final FileAnalyser fileAnalyser;
    private final Tar tar;
    private final Zip zip;

    public Extractor(FileAnalyser fileAnalyser, Tar tar, Zip zip) {
        this.fileAnalyser = fileAnalyser;
        this.tar = tar;
        this.zip = zip;
    }

    public List<File> uncompress(String inputFile, String outputDir, Consumer<ProgressEntity> onChange) {
        return this.uncompress(new File(inputFile), new File(outputDir), onChange);
    }

    public List<File> uncompress(File inputFile, File outputDir, Consumer<ProgressEntity> onChange) {
        this.LOGGER.info(String.format("Uncompressing %s to dir %s.", inputFile.getAbsolutePath(), outputDir.getAbsolutePath()));
        switch (this.fileAnalyser.getMimetype(inputFile)) {
            case "application/x-bzip2": {
                return this.tar.uncompressTarBz2File(inputFile, outputDir, onChange);
            }
            case "application/x-gzip": {
                return this.tar.uncompressTarGzFile(inputFile, outputDir, onChange);
            }
            case "application/x-xz": {
                return this.tar.uncompressTarXzFile(inputFile, outputDir, onChange);
            }
            case "application/zip": 
            case "application/x-dosexec": {
                return this.zip.uncompressZipFile(inputFile, outputDir, onChange);
            }
        }
        return this.tar.uncompressTarFile(inputFile, outputDir, onChange);
    }
}

