/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools;

import org.phoenicis.configuration.PhoenicisGlobalConfiguration;
import org.phoenicis.tools.archive.Extractor;
import org.phoenicis.tools.archive.Tar;
import org.phoenicis.tools.archive.Zip;
import org.phoenicis.tools.checksum.ChecksumCalculator;
import org.phoenicis.tools.config.CompatibleConfigFileFormatFactory;
import org.phoenicis.tools.files.FileAnalyser;
import org.phoenicis.tools.files.FileCopier;
import org.phoenicis.tools.files.FileSearcher;
import org.phoenicis.tools.files.FileSizeUtilities;
import org.phoenicis.tools.files.FileUtilities;
import org.phoenicis.tools.files.FreeSpaceFetcher;
import org.phoenicis.tools.http.Downloader;
import org.phoenicis.tools.lnk.LnkParser;
import org.phoenicis.tools.processes.ProcessUtils;
import org.phoenicis.tools.system.ArchitectureFetcher;
import org.phoenicis.tools.system.OperatingSystemFetcher;
import org.phoenicis.tools.system.ScreenManager;
import org.phoenicis.tools.system.SystemConfiguration;
import org.phoenicis.tools.system.opener.AutomaticOpener;
import org.phoenicis.tools.system.opener.Opener;
import org.phoenicis.tools.system.opener.OpenerProcessImplementation;
import org.phoenicis.tools.system.terminal.TerminalOpener;
import org.phoenicis.tools.win32.ExeAnalyser;
import org.phoenicis.win32.Win32Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

@Configuration
@Import(value={SystemConfiguration.class})
public class ToolsConfiguration {
    @Autowired
    private Win32Configuration win32Configuration;
    @Autowired
    private SystemConfiguration systemConfiguration;
    @Autowired
    private PhoenicisGlobalConfiguration phoenicisGlobalConfiguration;

    @Bean
    public CompatibleConfigFileFormatFactory compatibleConfigFileFormatFactory() {
        return new CompatibleConfigFileFormatFactory(this.phoenicisGlobalConfiguration.objectMapper());
    }

    @Bean
    public FileAnalyser fileAnalyser() {
        return new FileAnalyser();
    }

    @Bean
    public FileUtilities fileUtilities() {
        return new FileUtilities();
    }

    @Bean
    public FileSizeUtilities fileSizeUtilities() {
        return new FileSizeUtilities();
    }

    @Bean
    public FileSearcher fileSearcher() {
        return new FileSearcher();
    }

    @Bean
    Tar tar() {
        return new Tar(this.fileUtilities());
    }

    @Bean
    Zip zip() {
        return new Zip();
    }

    @Bean
    public Extractor extractor() {
        return new Extractor(this.fileAnalyser(), this.tar(), this.zip());
    }

    @Bean
    public FileCopier fileCopier() {
        return new FileCopier();
    }

    @Bean
    public FreeSpaceFetcher freeSpaceFetcher() {
        return new FreeSpaceFetcher();
    }

    @Bean
    public Downloader downloader() {
        return new Downloader(this.fileSizeUtilities());
    }

    @Bean
    public ChecksumCalculator checksumCalculator() {
        return new ChecksumCalculator();
    }

    @Bean
    public OperatingSystemFetcher operatingSystemFetcher() {
        return this.systemConfiguration.operatingSystemFetcher();
    }

    @Bean
    public ArchitectureFetcher architectureFetcher() {
        return new ArchitectureFetcher(this.operatingSystemFetcher());
    }

    @Bean
    public ExeAnalyser exeAnalyser() {
        return new ExeAnalyser(this.win32Configuration.peReader());
    }

    @Bean
    public TerminalOpener terminalOpener() {
        return this.systemConfiguration.terminalOpener();
    }

    @Bean
    public ProcessUtils processUtils() {
        return new ProcessUtils();
    }

    @Bean
    @Lazy
    Opener linuxOpener() {
        return new OpenerProcessImplementation("xdg-open");
    }

    @Bean
    @Lazy
    Opener macOsOpener() {
        return new OpenerProcessImplementation("open");
    }

    @Bean
    public Opener opener() {
        return new AutomaticOpener(this.linuxOpener(), this.macOsOpener(), this.operatingSystemFetcher());
    }

    @Bean
    public LnkParser lnkParser() {
        return new LnkParser(new org.phoenicis.lnk.LnkParser());
    }

    @Bean
    public ScreenManager screenManager() {
        return new ScreenManager();
    }
}

