/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.multithreading.debug;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.phoenicis.multithreading.ControlledThreadPoolExecutorService;
import org.slf4j.Logger;

class ControlledThreadPoolExecutorDebuggerWatcher
implements Runnable {
    private final long startTime = System.currentTimeMillis();
    private final MutableBoolean running;
    private final ExecutorService[] poolsToObserve;
    private final Logger logger;
    private final int sleepTime;
    private final Map<ExecutorService, Long> lastNumberOfTasks = new HashMap<ExecutorService, Long>();
    private final Map<ExecutorService, Long> lastTime = new HashMap<ExecutorService, Long>();

    ControlledThreadPoolExecutorDebuggerWatcher(MutableBoolean running, ExecutorService[] poolsToObserve, Logger logger, int sleepTime) {
        this.running = running;
        this.poolsToObserve = poolsToObserve;
        this.logger = logger;
        this.sleepTime = sleepTime;
        for (ExecutorService poolToObserve : poolsToObserve) {
            this.lastNumberOfTasks.put(poolToObserve, 0L);
            this.lastTime.put(poolToObserve, System.currentTimeMillis());
        }
    }

    public void stop() {
        this.running.setValue(false);
    }

    @Override
    public void run() {
        while (this.running.isTrue()) {
            for (ExecutorService executorServiceToWatch : this.poolsToObserve) {
                ControlledThreadPoolExecutorService pool = (ControlledThreadPoolExecutorService)executorServiceToWatch;
                long deltaStartTime = (System.currentTimeMillis() - this.startTime) / 1000L;
                long deltaLastTime = (System.currentTimeMillis() - this.lastTime.get(executorServiceToWatch)) / 1000L;
                long numberOfTasks = pool.getProcessed();
                long numberOfItems = pool.getQueue().size();
                long queueSize = numberOfItems + (long)pool.getQueue().remainingCapacity();
                long deltaNumberOfTasks = numberOfTasks - this.lastNumberOfTasks.get(executorServiceToWatch);
                this.logger.info(String.format("[ %10s ] Done: %20s, Running: %20s, Queue: %10s, Avg: %6s t/s, Speed: %6s t/s", pool.getName(), numberOfTasks, pool.getActiveCount(), String.format("%s / %s", numberOfItems, queueSize), deltaStartTime == 0L ? 0L : numberOfTasks / deltaStartTime, deltaLastTime == 0L ? 0L : deltaNumberOfTasks / deltaLastTime));
                this.lastTime.put(executorServiceToWatch, System.currentTimeMillis());
                this.lastNumberOfTasks.put(executorServiceToWatch, numberOfTasks);
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException ignored) {
                break;
            }
        }
    }
}

