/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.multithreading.debug;

import java.util.concurrent.ExecutorService;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.multithreading.debug.ControlledThreadPoolExecutorDebuggerWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class ControlledThreadPoolExecutorDebugger
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlledThreadPoolExecutorDebugger.class);
    private static final int REFRESH_TIME = 5000;
    private final ExecutorService executorService;
    private final ExecutorService[] poolsToObserve;
    private MutableBoolean running = new MutableBoolean(true);
    private ControlledThreadPoolExecutorDebuggerWatcher watcher;

    public ControlledThreadPoolExecutorDebugger(ExecutorService executorService, ExecutorService ... poolsToObserve) {
        this.poolsToObserve = poolsToObserve;
        this.executorService = executorService;
    }

    public void start() {
        if (this.watcher == null) {
            this.watcher = new ControlledThreadPoolExecutorDebuggerWatcher(this.running, this.poolsToObserve, LOGGER, 5000);
            this.executorService.submit(this.watcher);
        }
    }

    public void stop() {
        if (this.watcher != null) {
            this.watcher.stop();
            this.watcher = null;
        }
    }

    @Override
    @PreDestroy
    public void close() {
        this.stop();
        this.executorService.shutdownNow();
        this.running.setValue(false);
    }
}

