/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.multithreading;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.phoenicis.multithreading.ControlledThreadPoolExecutorService;
import org.phoenicis.multithreading.ControlledThreadPoolExecutorServiceCloser;
import org.phoenicis.multithreading.debug.ControlledThreadPoolExecutorDebugger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MultithreadingConfiguration {
    @Bean
    public ControlledThreadPoolExecutorService scriptExecutorService() {
        return new ControlledThreadPoolExecutorService("Scripts", 10, 50);
    }

    @Bean
    public ControlledThreadPoolExecutorService appsExecutorService() {
        return new ControlledThreadPoolExecutorService("Apps", 1, 1);
    }

    @Bean
    public ControlledThreadPoolExecutorService containersExecutorService() {
        return new ControlledThreadPoolExecutorService("Containers", 1, 5);
    }

    @Bean
    public ControlledThreadPoolExecutorServiceCloser controllerThreadPoolExecutorServiceCloser() {
        return new ControlledThreadPoolExecutorServiceCloser(this.appsExecutorService(), this.containersExecutorService(), this.scriptExecutorService());
    }

    @Bean
    public ExecutorService debugExecutorService() {
        return Executors.newSingleThreadExecutor();
    }

    @Bean
    public ControlledThreadPoolExecutorDebugger controlledThreadPoolExecutorDebugger() {
        return new ControlledThreadPoolExecutorDebugger(this.debugExecutorService(), this.scriptExecutorService(), this.appsExecutorService(), this.containersExecutorService());
    }
}

