/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.multithreading;

import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.phoenicis.multithreading.ControlledThreadPoolExecutorService;

public class ControlledThreadPoolExecutorServiceCloser
implements AutoCloseable {
    private final ControlledThreadPoolExecutorService[] executorServices;
    private boolean closeImmediately = false;

    ControlledThreadPoolExecutorServiceCloser(ControlledThreadPoolExecutorService ... executorServices) {
        this.executorServices = executorServices;
    }

    public void setCloseImmediately(boolean closeImmediately) {
        this.closeImmediately = closeImmediately;
    }

    @Override
    @PreDestroy
    public void close() throws InterruptedException {
        for (ControlledThreadPoolExecutorService executorService : this.executorServices) {
            executorService.sendShutdownSignal();
            if (!this.closeImmediately) {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            executorService.shutdownNow();
        }
    }
}

