/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.multithreading;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlledThreadPoolExecutorService
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlledThreadPoolExecutorService.class);
    private final Semaphore semaphore;
    private final String name;
    private final AtomicLong processed = new AtomicLong(0L);
    private final AtomicLong remainingTasks = new AtomicLong(0L);
    private final int numberOfThreads;
    private boolean shouldShutdown = false;

    public ControlledThreadPoolExecutorService(String name, int numberOfThread, int queueSize) {
        super(numberOfThread, numberOfThread, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(queueSize));
        this.semaphore = new Semaphore(queueSize);
        this.name = name;
        this.numberOfThreads = numberOfThread;
    }

    @Override
    public void execute(Runnable runnable) {
        try {
            this.setCorePoolSize(this.numberOfThreads);
            this.remainingTasks.incrementAndGet();
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        super.execute(runnable);
    }

    @Override
    public void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        if (throwable != null) {
            LOGGER.error(ExceptionUtils.getFullStackTrace((Throwable)throwable));
        }
        this.semaphore.release();
        this.processed.addAndGet(1L);
        if (this.remainingTasks.decrementAndGet() == 0L) {
            this.setCorePoolSize(1);
            if (this.shouldShutdown) {
                this.shutdown();
            }
        }
    }

    public void sendShutdownSignal() {
        if (this.remainingTasks.get() == 0L) {
            this.shutdown();
        }
        this.shouldShutdown = true;
    }

    long getNumberOfProcessedTasks() {
        return this.processed.get();
    }

    int getQueueSize() {
        return this.getQueue().size() + this.getQueue().remainingCapacity();
    }

    int getQueueNumberOfItems() {
        return this.getQueue().size() + this.numberOfThreads;
    }

    public String getName() {
        return this.name;
    }

    public long getProcessed() {
        return this.processed.get();
    }
}

