/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.library.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Comparator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonDeserialize(builder=Builder.class)
public class ShortcutInfoDTO {
    private final String name;
    private final String category;
    private final String description;

    private ShortcutInfoDTO(Builder builder) {
        this.name = builder.name;
        this.category = builder.category;
        this.description = builder.description;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public static Comparator<ShortcutInfoDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortcutInfoDTO that = (ShortcutInfoDTO)o;
        return new EqualsBuilder().append((Object)this.name, (Object)that.name).append((Object)this.category, (Object)that.category).append((Object)this.description, (Object)that.description).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.category).append((Object)this.description).toHashCode();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private String name;
        private String category;
        private String description;

        public Builder() {
        }

        public Builder(ShortcutInfoDTO shortcutDTO) {
            this.name = shortcutDTO.name;
            this.category = shortcutDTO.category;
            this.description = shortcutDTO.description;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public ShortcutInfoDTO build() {
            return new ShortcutInfoDTO(this);
        }

        public String getName() {
            return this.name;
        }

        public String getCategory() {
            return this.category;
        }
    }
}

