/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.library.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.Comparator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.phoenicis.library.dto.ShortcutInfoDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
public class ShortcutDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortcutDTO.class);
    private final String id;
    private final ShortcutInfoDTO info;
    private final URI icon;
    private final URI categoryIcon;
    private final URI miniature;
    private final String script;

    private ShortcutDTO(Builder builder) {
        if (builder.id != null) {
            if (builder.id.matches("^[a-zA-Z0-9 ]+$")) {
                this.id = builder.id;
            } else {
                LOGGER.warn(String.format("Shortcut ID (%s) contains invalid characters, will remove them.", builder.id));
                this.id = builder.id.replaceAll("[^a-zA-Z0-9 ]", "");
            }
        } else {
            this.id = null;
        }
        this.info = builder.info;
        this.icon = builder.icon;
        this.categoryIcon = builder.categoryIcon;
        this.miniature = builder.miniature;
        this.script = builder.script;
    }

    public ShortcutInfoDTO getInfo() {
        return this.info;
    }

    public URI getIcon() {
        return this.icon;
    }

    public URI getCategoryIcon() {
        return this.categoryIcon;
    }

    public URI getMiniature() {
        return this.miniature;
    }

    public String getId() {
        return this.id;
    }

    public String getScript() {
        return this.script;
    }

    public static Comparator<ShortcutDTO> nameComparator() {
        return (o1, o2) -> o1.getId().compareToIgnoreCase(o2.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortcutDTO that = (ShortcutDTO)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.info, (Object)that.info).append((Object)this.icon, (Object)that.icon).append((Object)this.categoryIcon, (Object)that.categoryIcon).append((Object)this.miniature, (Object)that.miniature).append((Object)this.script, (Object)that.script).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.info).append((Object)this.icon).append((Object)this.categoryIcon).append((Object)this.miniature).append((Object)this.script).toHashCode();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private String id;
        private ShortcutInfoDTO info;
        private URI icon;
        private URI categoryIcon;
        private URI miniature;
        private String script;

        public Builder() {
        }

        public Builder(ShortcutDTO shortcutDTO) {
            this.info = shortcutDTO.info;
            this.id = shortcutDTO.id;
            this.icon = shortcutDTO.icon;
            this.categoryIcon = shortcutDTO.categoryIcon;
            this.miniature = shortcutDTO.miniature;
            this.script = shortcutDTO.script;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withInfo(ShortcutInfoDTO info) {
            this.info = info;
            return this;
        }

        public Builder withIcon(URI icon) {
            this.icon = icon;
            return this;
        }

        public Builder withCategoryIcon(URI categoryIcon) {
            this.categoryIcon = categoryIcon;
            return this;
        }

        public Builder withMiniature(URI miniature) {
            this.miniature = miniature;
            return this;
        }

        public Builder withScript(String script) {
            this.script = script;
            return this;
        }

        public ShortcutDTO build() {
            return new ShortcutDTO(this);
        }
    }
}

