/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.library.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.File;
import java.net.URI;
import java.util.Comparator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonDeserialize(builder=Builder.class)
public class ShortcutCreationDTO {
    private final String name;
    private final String category;
    private final String description;
    private final URI icon;
    private final URI miniature;
    private final File executable;

    private ShortcutCreationDTO(Builder builder) {
        this.name = builder.name;
        this.category = builder.category;
        this.description = builder.description;
        this.icon = builder.icon;
        this.miniature = builder.miniature;
        this.executable = builder.executable;
    }

    public URI getIcon() {
        return this.icon;
    }

    public URI getMiniature() {
        return this.miniature;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public File getExecutable() {
        return this.executable;
    }

    public static Comparator<ShortcutCreationDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortcutCreationDTO that = (ShortcutCreationDTO)o;
        return new EqualsBuilder().append((Object)this.name, (Object)that.name).append((Object)this.category, (Object)that.category).append((Object)this.description, (Object)that.description).append((Object)this.icon, (Object)that.icon).append((Object)this.miniature, (Object)that.miniature).append((Object)this.executable, (Object)that.executable).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.category).append((Object)this.description).append((Object)this.icon).append((Object)this.miniature).append((Object)this.executable).toHashCode();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private String name;
        private String category;
        private String description;
        private URI icon;
        private URI miniature;
        private File executable;

        public Builder() {
        }

        public Builder(ShortcutCreationDTO shortcutDTO) {
            this.name = shortcutDTO.name;
            this.category = shortcutDTO.category;
            this.description = shortcutDTO.description;
            this.icon = shortcutDTO.icon;
            this.miniature = shortcutDTO.miniature;
            this.executable = shortcutDTO.executable;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withIcon(URI icon) {
            this.icon = icon;
            return this;
        }

        public Builder withMiniature(URI miniature) {
            this.miniature = miniature;
            return this;
        }

        public Builder withExecutable(File executable) {
            this.executable = executable;
            return this;
        }

        public ShortcutCreationDTO build() {
            return new ShortcutCreationDTO(this);
        }

        public String getName() {
            return this.name;
        }
    }
}

