/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.library.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.configuration.localisation.Translatable;
import org.phoenicis.configuration.localisation.TranslatableBuilder;
import org.phoenicis.configuration.localisation.Translate;
import org.phoenicis.library.dto.ShortcutDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@Translatable
public class ShortcutCategoryDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortcutCategoryDTO.class);
    private final String id;
    private final String name;
    private final String description;
    private final List<ShortcutDTO> shortcuts;
    private URI icon;

    private ShortcutCategoryDTO(Builder builder) {
        if (builder.id != null) {
            if (builder.id.matches("^[a-zA-Z0-9]+$")) {
                this.id = builder.id;
            } else {
                LOGGER.warn(String.format("Shortcut category ID (%s) contains invalid characters, will remove them.", builder.id));
                this.id = builder.id.replaceAll("[^a-zA-Z0-9]", "");
            }
        } else {
            this.id = null;
        }
        this.name = builder.name == null ? builder.id : builder.name;
        this.description = builder.description;
        this.shortcuts = Collections.unmodifiableList(builder.shortcuts);
        this.icon = builder.icon;
    }

    public String getId() {
        return this.id;
    }

    @Translate
    public String getName() {
        return this.name;
    }

    @Translate
    public String getDescription() {
        return this.description;
    }

    public List<ShortcutDTO> getShortcuts() {
        return this.shortcuts;
    }

    public URI getIcon() {
        return this.icon;
    }

    public static Comparator<ShortcutCategoryDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortcutCategoryDTO that = (ShortcutCategoryDTO)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.name, (Object)that.name).append((Object)this.description, (Object)that.description).append(this.shortcuts, that.shortcuts).append((Object)this.icon, (Object)that.icon).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.name).append((Object)this.description).append(this.shortcuts).append((Object)this.icon).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.name).toString();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    @TranslatableBuilder
    public static class Builder {
        private String id;
        private String name;
        private String description;
        private List<ShortcutDTO> shortcuts = new ArrayList<ShortcutDTO>();
        private URI icon;

        public Builder() {
        }

        public Builder(ShortcutCategoryDTO categoryDTO) {
            this.withId(categoryDTO.getId()).withName(categoryDTO.getName()).withDescription(categoryDTO.getDescription()).withShortcuts(categoryDTO.getShortcuts()).withIcon(categoryDTO.getIcon());
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withShortcuts(List<ShortcutDTO> shortcuts) {
            this.shortcuts = shortcuts;
            return this;
        }

        public Builder withIcon(URI iconPath) {
            this.icon = iconPath;
            return this;
        }

        public ShortcutCategoryDTO build() {
            return new ShortcutCategoryDTO(this);
        }
    }
}

