/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.library;

import java.util.List;
import java.util.function.Consumer;
import org.graalvm.polyglot.Value;
import org.phoenicis.library.LibraryManager;
import org.phoenicis.library.ShortcutReader;
import org.phoenicis.library.dto.ShortcutDTO;
import org.phoenicis.scripts.interpreter.ScriptInterpreter;
import org.phoenicis.scripts.session.InteractiveScriptSession;

public class ShortcutRunner {
    private final ScriptInterpreter scriptInterpreter;
    private final LibraryManager libraryManager;

    public ShortcutRunner(ScriptInterpreter scriptInterpreter, LibraryManager libraryManager) {
        this.scriptInterpreter = scriptInterpreter;
        this.libraryManager = libraryManager;
    }

    public boolean shortcutExists(String shortcutName) {
        ShortcutDTO shortcut = this.libraryManager.fetchShortcutsFromName(shortcutName);
        return shortcut != null;
    }

    public boolean run(String shortcutName, List<String> arguments, Consumer<Exception> errorCallback) {
        ShortcutDTO shortcut = this.libraryManager.fetchShortcutsFromName(shortcutName);
        if (shortcut == null) {
            return false;
        }
        this.run(shortcut, arguments, errorCallback);
        return true;
    }

    public void run(ShortcutDTO shortcutDTO, List<String> arguments, Consumer<Exception> errorCallback) {
        InteractiveScriptSession interactiveScriptSession = this.scriptInterpreter.createInteractiveSession();
        interactiveScriptSession.eval("include(\"engines.wine.shortcuts.reader\");", result -> {
            Value shortcutReaderClass = (Value)result;
            ShortcutReader shortcutReader = (ShortcutReader)shortcutReaderClass.newInstance(new Object[0]).as(ShortcutReader.class);
            shortcutReader.of(shortcutDTO);
            shortcutReader.run(arguments);
        }, errorCallback);
    }

    public void stop(ShortcutDTO shortcutDTO, Consumer<Exception> errorCallback) {
        InteractiveScriptSession interactiveScriptSession = this.scriptInterpreter.createInteractiveSession();
        interactiveScriptSession.eval("include(\"engines.wine.shortcuts.reader\");", result -> {
            Value shortcutReaderClass = (Value)result;
            ShortcutReader shortcutReader = (ShortcutReader)shortcutReaderClass.newInstance(new Object[0]).as(ShortcutReader.class);
            shortcutReader.of(shortcutDTO);
            shortcutReader.stop();
        }, errorCallback);
    }
}

