/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.library;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.graalvm.polyglot.Value;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.library.LibraryManager;
import org.phoenicis.library.ShortcutReader;
import org.phoenicis.library.dto.ShortcutDTO;
import org.phoenicis.library.dto.ShortcutInfoDTO;
import org.phoenicis.scripts.interpreter.ScriptInterpreter;
import org.phoenicis.scripts.session.InteractiveScriptSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class ShortcutManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortcutManager.class);
    private static final String ENCODING = "UTF-8";
    private final String shortcutDirectory;
    private final LibraryManager libraryManager;
    private final ScriptInterpreter scriptInterpreter;
    private ObjectMapper objectMapper;
    private final String desktopShortcutDirectory;

    ShortcutManager(String shortcutDirectory, String desktopShortcutDirectory, LibraryManager libraryManager, ScriptInterpreter scriptInterpreter, ObjectMapper objectMapper) {
        this.shortcutDirectory = shortcutDirectory;
        this.desktopShortcutDirectory = desktopShortcutDirectory;
        this.libraryManager = libraryManager;
        this.scriptInterpreter = scriptInterpreter;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createShortcut(ShortcutDTO shortcutDTO) {
        ShortcutInfoDTO shortcutInfo = shortcutDTO.getInfo();
        String baseName = shortcutDTO.getId();
        File shortcutDirectoryFile = new File(this.shortcutDirectory);
        File infoFile = new File(shortcutDirectoryFile, baseName + ".info");
        File scriptFile = new File(shortcutDirectoryFile, baseName + ".shortcut");
        File iconFile = new File(shortcutDirectoryFile, baseName + ".icon");
        File categoryIconFile = new File(shortcutDirectoryFile, baseName + "Category.icon");
        File miniatureFile = new File(shortcutDirectoryFile, baseName + ".miniature");
        if (!shortcutDirectoryFile.exists()) {
            shortcutDirectoryFile.mkdirs();
        }
        try {
            File file;
            this.objectMapper.writeValue(infoFile, (Object)shortcutInfo);
            FileUtils.writeStringToFile((File)scriptFile, (String)shortcutDTO.getScript(), (String)ENCODING);
            try {
                if (shortcutDTO.getIcon() != null && (file = this.createFileWithFallback(shortcutDTO.getIcon(), "phoenicis.png")).exists()) {
                    FileUtils.copyFile((File)file, (File)iconFile);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                LOGGER.warn("Error while creating shortcut icon", (Throwable)e);
            }
            try {
                if (shortcutDTO.getCategoryIcon() != null && (file = this.createFileWithFallback(shortcutDTO.getCategoryIcon(), "phoenicis.png")).exists()) {
                    FileUtils.copyFile((File)file, (File)categoryIconFile);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                LOGGER.warn("Error while creating shortcut category icon", (Throwable)e);
            }
            try {
                if (shortcutDTO.getMiniature() != null && (file = this.createFileWithFallback(shortcutDTO.getMiniature(), "defaultMiniature.png")).exists()) {
                    FileUtils.copyFile((File)file, (File)miniatureFile);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                LOGGER.warn("Error while creating miniature", (Throwable)e);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error while creating shortcut", (Throwable)e);
        }
        finally {
            this.libraryManager.refresh();
        }
        if (this.desktopShortcutDirectory != null) {
            File desktopShortcutDirectoryFile = new File(this.desktopShortcutDirectory);
            File desktopShortcutFile = new File(desktopShortcutDirectoryFile, baseName + ".desktop");
            try {
                String content = "[Desktop Entry]\nName=" + shortcutInfo.getName() + "\nType=Application\nIcon=" + miniatureFile.getAbsolutePath() + "\nExec=phoenicis-cli -run \"" + shortcutInfo.getName() + "\"";
                FileUtils.writeStringToFile((File)desktopShortcutFile, (String)content, (String)ENCODING);
            }
            catch (IOException e) {
                LOGGER.warn("Error while creating .desktop", (Throwable)e);
            }
        }
    }

    public void uninstallFromShortcut(ShortcutDTO shortcutDTO, Consumer<Exception> errorCallback) {
        InteractiveScriptSession interactiveScriptSession = this.scriptInterpreter.createInteractiveSession();
        interactiveScriptSession.eval("include(\"engines.wine.shortcuts.reader\");", result -> {
            Value shortcutReaderClass = (Value)result;
            ShortcutReader shortcutReader = (ShortcutReader)shortcutReaderClass.newInstance(new Object[0]).as(ShortcutReader.class);
            shortcutReader.of(shortcutDTO);
            shortcutReader.uninstall();
        }, errorCallback);
    }

    public void deleteShortcut(ShortcutDTO shortcutDTO) {
        File desktopShortcutDirectoryFile;
        File desktopShortcutFile;
        String baseName = shortcutDTO.getId();
        File shortcutDirectory = new File(this.shortcutDirectory);
        File infoFile = new File(shortcutDirectory, baseName + ".info");
        File scriptFile = new File(shortcutDirectory, baseName + ".shortcut");
        File iconFile = new File(shortcutDirectory, baseName + ".icon");
        File categoryIconFile = new File(shortcutDirectory, baseName + "Category.icon");
        File miniatureFile = new File(shortcutDirectory, baseName + ".miniature");
        if (infoFile.exists()) {
            infoFile.delete();
        }
        if (scriptFile.exists()) {
            scriptFile.delete();
        }
        if (iconFile.exists()) {
            iconFile.delete();
        }
        if (categoryIconFile.exists()) {
            categoryIconFile.delete();
        }
        if (miniatureFile.exists()) {
            miniatureFile.delete();
        }
        if (this.desktopShortcutDirectory != null && (desktopShortcutFile = new File(desktopShortcutDirectoryFile = new File(this.desktopShortcutDirectory), baseName + ".desktop")).exists()) {
            desktopShortcutFile.delete();
        }
        this.libraryManager.refresh();
    }

    public void updateShortcut(ShortcutDTO shortcutDTO) {
        boolean keepMiniature;
        boolean keepIcon;
        boolean keepIcon2;
        String baseName = shortcutDTO.getId();
        File shortcutDirectory = new File(this.shortcutDirectory);
        File iconFile = new File(shortcutDirectory, baseName + ".icon");
        File iconBackup = new File(shortcutDirectory, baseName + ".icon_backup");
        URI shortcutIcon = shortcutDTO.getIcon();
        if (shortcutIcon != null && shortcutIcon.getPath() != null && (keepIcon2 = shortcutIcon.getPath().equals(iconFile.getPath()))) {
            try {
                Files.move(iconFile.toPath(), iconBackup.toPath(), new CopyOption[0]);
                shortcutDTO = new ShortcutDTO.Builder(shortcutDTO).withIcon(iconBackup.toURI()).build();
            }
            catch (IOException e) {
                LOGGER.error("Could not backup icon.", (Throwable)e);
            }
        }
        File categoryIconFile = new File(shortcutDirectory, baseName + "Category.icon");
        File categoryIconBackup = new File(shortcutDirectory, baseName + "Category.icon_backup");
        URI shortcutCategoryIcon = shortcutDTO.getCategoryIcon();
        if (shortcutCategoryIcon != null && shortcutCategoryIcon.getPath() != null && (keepIcon = shortcutCategoryIcon.getPath().equals(categoryIconFile.getPath()))) {
            try {
                Files.move(categoryIconFile.toPath(), categoryIconBackup.toPath(), new CopyOption[0]);
                shortcutDTO = new ShortcutDTO.Builder(shortcutDTO).withCategoryIcon(categoryIconBackup.toURI()).build();
            }
            catch (IOException e) {
                LOGGER.error("Could not backup category icon.", (Throwable)e);
            }
        }
        File miniatureFile = new File(shortcutDirectory, baseName + ".miniature");
        File miniatureBackup = new File(shortcutDirectory, baseName + ".miniature_backup");
        URI shortcutMiniature = shortcutDTO.getMiniature();
        if (shortcutMiniature != null && shortcutMiniature.getPath() != null && (keepMiniature = shortcutMiniature.getPath().equals(miniatureFile.getPath()))) {
            try {
                Files.move(miniatureFile.toPath(), miniatureBackup.toPath(), new CopyOption[0]);
                shortcutDTO = new ShortcutDTO.Builder(shortcutDTO).withMiniature(miniatureBackup.toURI()).build();
            }
            catch (IOException e) {
                LOGGER.error("Could not backup miniature.", (Throwable)e);
            }
        }
        this.deleteShortcut(shortcutDTO);
        this.createShortcut(shortcutDTO);
        if (iconBackup.exists()) {
            iconBackup.delete();
        }
        if (miniatureBackup.exists()) {
            miniatureBackup.delete();
        }
    }

    private File createFileWithFallback(URI path, String resource) {
        try {
            return new File(path);
        }
        catch (IllegalArgumentException e) {
            return new File(this.getClass().getResource(resource).toExternalForm());
        }
    }
}

