/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.library;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.library.dto.ShortcutCategoryDTO;
import org.phoenicis.library.dto.ShortcutDTO;
import org.phoenicis.library.dto.ShortcutInfoDTO;
import org.phoenicis.multithreading.functional.NullRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class LibraryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryManager.class);
    private final String shortcutDirectory;
    private ObjectMapper objectMapper;
    private Runnable onUpdate = new NullRunnable();

    public LibraryManager(String shortcutDirectory, ObjectMapper objectMapper) {
        this.shortcutDirectory = shortcutDirectory;
        this.objectMapper = objectMapper;
    }

    public List<ShortcutCategoryDTO> fetchShortcuts() {
        File shortcutDirectoryFile = new File(this.shortcutDirectory);
        if (!shortcutDirectoryFile.exists()) {
            shortcutDirectoryFile.mkdirs();
            return Collections.emptyList();
        }
        File[] directoryContent = shortcutDirectoryFile.listFiles();
        if (directoryContent == null) {
            return Collections.emptyList();
        }
        HashMap categoryMap = new HashMap();
        for (File file : directoryContent) {
            if (!"shortcut".equals(FilenameUtils.getExtension((String)file.getName()))) continue;
            ShortcutDTO shortcut = this.fetchShortcutDTO(shortcutDirectoryFile, file);
            String categoryId = shortcut.getInfo().getCategory();
            if (!categoryMap.containsKey(categoryId)) {
                categoryMap.put(categoryId, new ArrayList());
            }
            ((List)categoryMap.get(categoryId)).add(shortcut);
        }
        ArrayList<ShortcutCategoryDTO> shortcuts = new ArrayList<ShortcutCategoryDTO>();
        for (Map.Entry entry : categoryMap.entrySet()) {
            ((List)entry.getValue()).sort(ShortcutDTO.nameComparator());
            ShortcutCategoryDTO category = new ShortcutCategoryDTO.Builder().withId((String)entry.getKey()).withName((String)entry.getKey()).withShortcuts((List)entry.getValue()).withIcon(((ShortcutDTO)((List)entry.getValue()).get(0)).getCategoryIcon()).build();
            shortcuts.add((ShortcutCategoryDTO)Localisation.tr((Object)category));
        }
        return shortcuts;
    }

    public ShortcutDTO fetchShortcutsFromName(String name) {
        for (ShortcutCategoryDTO shortcutCategoryDTO : this.fetchShortcuts()) {
            for (ShortcutDTO shortcutDTO : shortcutCategoryDTO.getShortcuts()) {
                if (!name.equals(shortcutDTO.getInfo().getName())) continue;
                return shortcutDTO;
            }
        }
        return null;
    }

    public void setOnUpdate(Runnable onUpdate) {
        this.onUpdate = onUpdate;
    }

    private ShortcutDTO fetchShortcutDTO(File shortcutDirectory, File file) {
        ShortcutInfoDTO.Builder shortcutInfoDTOBuilder;
        String baseName = FilenameUtils.getBaseName((String)file.getName());
        File infoFile = new File(shortcutDirectory, baseName + ".info");
        File iconFile = new File(shortcutDirectory, baseName + ".icon");
        File categoryIconFile = new File(shortcutDirectory, baseName + "Category.icon");
        File miniatureFile = new File(shortcutDirectory, baseName + ".miniature");
        if (infoFile.exists()) {
            ShortcutInfoDTO shortcutInfoDTOFromJsonFile = this.unSerializeShortcutInfo(infoFile);
            shortcutInfoDTOBuilder = new ShortcutInfoDTO.Builder(shortcutInfoDTOFromJsonFile);
        } else {
            shortcutInfoDTOBuilder = new ShortcutInfoDTO.Builder();
            shortcutInfoDTOBuilder.withName(baseName);
        }
        if (StringUtils.isBlank((String)shortcutInfoDTOBuilder.getName())) {
            shortcutInfoDTOBuilder.withName(baseName);
        }
        if (StringUtils.isBlank((String)shortcutInfoDTOBuilder.getCategory())) {
            shortcutInfoDTOBuilder.withCategory("Other");
        }
        ShortcutInfoDTO shortcutInfoDTO = shortcutInfoDTOBuilder.build();
        try {
            URI icon = iconFile.exists() ? iconFile.toURI() : this.getClass().getResource("phoenicis.png").toURI();
            URI categoryIcon = categoryIconFile.exists() ? categoryIconFile.toURI() : this.getClass().getResource("phoenicis.png").toURI();
            URI miniature = miniatureFile.exists() ? miniatureFile.toURI() : this.getClass().getResource("defaultMiniature.png").toURI();
            return new ShortcutDTO.Builder().withId(baseName).withInfo(shortcutInfoDTO).withScript(IOUtils.toString((InputStream)new FileInputStream(file), (String)"UTF-8")).withIcon(icon).withCategoryIcon(categoryIcon).withMiniature(miniature).build();
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public void refresh() {
        this.onUpdate.run();
    }

    private ShortcutInfoDTO unSerializeShortcutInfo(File jsonFile) {
        try {
            return (ShortcutInfoDTO)this.objectMapper.readValue(jsonFile, ShortcutInfoDTO.class);
        }
        catch (IOException e) {
            LOGGER.debug("JSON file not found");
            return new ShortcutInfoDTO.Builder().build();
        }
    }
}

