/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.library;

import org.phoenicis.configuration.PhoenicisGlobalConfiguration;
import org.phoenicis.library.LibraryManager;
import org.phoenicis.library.ShortcutManager;
import org.phoenicis.library.ShortcutRunner;
import org.phoenicis.scripts.ScriptsConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LibraryConfiguration {
    @Autowired
    private ScriptsConfiguration scriptsConfiguration;
    @Autowired
    private PhoenicisGlobalConfiguration phoenicisGlobalConfiguration;
    @Value(value="${application.user.shortcuts}")
    private String shortcutDirectory;
    @Value(value="${application.user.desktopShortcuts}")
    private String desktopShortcutDirectory;

    @Bean
    public LibraryManager libraryManager() {
        return new LibraryManager(this.shortcutDirectory, this.phoenicisGlobalConfiguration.objectMapper());
    }

    @Bean
    public ShortcutManager shortcutManager() {
        return new ShortcutManager(this.shortcutDirectory, this.desktopShortcutDirectory, this.libraryManager(), this.scriptsConfiguration.scriptInterpreter(), this.phoenicisGlobalConfiguration.objectMapper());
    }

    @Bean
    public ShortcutRunner shortcutRunner() {
        return new ShortcutRunner(this.scriptsConfiguration.scriptInterpreter(), this.libraryManager());
    }
}

