/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Platforms(value={Platform.HOSTED_ONLY.class})
final class JNIFromLibGraalEntryPoints {
    JNIFromLibGraalEntryPoints() {
    }

    static Throwable updateStackTrace(Throwable target, String[] rawElements) {
        StackTraceElement[] elements = new StackTraceElement[rawElements.length];
        for (int i = 0; i < rawElements.length; ++i) {
            String[] parts = rawElements[i].split("\\|");
            String className = parts[0];
            String methodName = parts[1];
            String fileName = parts[2];
            int lineNumber = Integer.parseInt(parts[3]);
            elements[i] = new StackTraceElement(className, methodName, fileName.isEmpty() ? null : fileName, lineNumber);
        }
        target.setStackTrace(elements);
        return target;
    }

    static Throwable createException(String message) {
        return new RuntimeException(message);
    }

    static StackTraceElement[] getStackTrace(Throwable throwable) {
        return throwable.getStackTrace();
    }

    static String getStackTraceElementClassName(StackTraceElement element) {
        return element.getClassName();
    }

    static String getStackTraceElementFileName(StackTraceElement element) {
        return element.getFileName();
    }

    static int getStackTraceElementLineNumber(StackTraceElement element) {
        return element.getLineNumber();
    }

    static String getStackTraceElementMethodName(StackTraceElement element) {
        return element.getMethodName();
    }

    static String getThrowableMessage(Throwable t) {
        return t.getMessage();
    }

    static String getClassName(Class<?> clz) {
        return clz.getName();
    }
}

