/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIExceptionWrapper;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.libgraal.jni.annotation.FromLibGraalId;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class FromLibGraalCalls<T extends Enum<T>> {
    private static final Map<String, JNIClass> classes = new ConcurrentHashMap<String, JNIClass>();
    private static final ThreadLocal<Boolean> inExceptionHandler = new ThreadLocal();
    private final EnumMap<T, JNIMethod<T>> methods;
    private volatile JNI.JClass peer;
    private static final Set<String> HotSpotCallNames;

    protected FromLibGraalCalls(Class<T> idType) {
        this.methods = new EnumMap(idType);
    }

    protected abstract JNI.JClass resolvePeer(JNI.JNIEnv var1);

    @HotSpotCall
    public final void callVoid(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethod<T> method = this.getJNIMethod(env, id, Void.TYPE);
        this.traceCall(id);
        env.getFunctions().getCallStaticVoidMethodA().call(env, this.peer(env), method.jniId, args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, new Class[0]);
    }

    @HotSpotCall
    public final boolean callBoolean(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethod<T> method = this.getJNIMethod(env, id, Boolean.TYPE);
        this.traceCall(id);
        boolean res = env.getFunctions().getCallStaticBooleanMethodA().call(env, this.peer(env), method.jniId, args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, new Class[0]);
        return res;
    }

    @HotSpotCall
    public final long callLong(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethod<T> method = this.getJNIMethod(env, id, Long.TYPE);
        this.traceCall(id);
        long res = env.getFunctions().getCallStaticLongMethodA().call(env, this.peer(env), method.jniId, args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, new Class[0]);
        return res;
    }

    @HotSpotCall
    public final int callInt(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethod<T> method = this.getJNIMethod(env, id, Integer.TYPE);
        this.traceCall(id);
        int res = env.getFunctions().getCallStaticIntMethodA().call(env, this.peer(env), method.jniId, args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, new Class[0]);
        return res;
    }

    @HotSpotCall
    public final <R extends JNI.JObject> R callJObject(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethod<T> method = this.getJNIMethod(env, id, Object.class);
        this.traceCall(id);
        JNI.JObject res = env.getFunctions().getCallStaticObjectMethodA().call(env, this.peer(env), method.jniId, args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, new Class[0]);
        return (R)res;
    }

    public static JNI.JClass getJNIClass(JNI.JNIEnv env, Class<?> clazz) {
        if (clazz.isArray()) {
            throw new UnsupportedOperationException("Array classes are not supported");
        }
        return FromLibGraalCalls.getJNIClassImpl((JNI.JNIEnv)env, (String)clazz.getName()).jclass;
    }

    public static JNI.JClass getJNIClass(JNI.JNIEnv env, String className) {
        return FromLibGraalCalls.getJNIClassImpl((JNI.JNIEnv)env, (String)className).jclass;
    }

    private void traceCall(T id) {
        JNIUtil.trace(1, "LIBGRAAL->HS: %s", id);
    }

    private static JNIClass getJNIClassImpl(final JNI.JNIEnv env, String className) {
        try {
            return classes.computeIfAbsent(className, new Function<String, JNIClass>(){

                @Override
                public JNIClass apply(String name) {
                    JNI.JClass clazz;
                    JNI.JObject classLoader = JNIUtil.getJVMCIClassLoader(env);
                    JNI.JClass jClass = clazz = classLoader.isNull() ? JNIUtil.findClass(env, JNIUtil.getBinaryName(name)) : JNIUtil.findClass(env, classLoader, JNIUtil.getBinaryName(name));
                    if (clazz.isNull()) {
                        JNIUtil.ExceptionClear(env);
                        throw new InternalError("Cannot load class: " + name);
                    }
                    return new JNIClass(name, JNIUtil.NewGlobalRef(env, clazz, "Class<" + name + ">"));
                }
            });
        }
        catch (InternalError ie) {
            if (inExceptionHandler.get() != Boolean.TRUE) {
                inExceptionHandler.set(true);
                try {
                    JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, new Class[0]);
                }
                finally {
                    inExceptionHandler.remove();
                }
            }
            throw ie;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JNIMethod<T> getJNIMethod(final JNI.JNIEnv env, T hcId, Class<?> expectedReturnType) {
        assert (((FromLibGraalId)hcId).getReturnType() == expectedReturnType || expectedReturnType.isAssignableFrom(((FromLibGraalId)hcId).getReturnType()));
        try {
            return (JNIMethod)this.methods.computeIfAbsent(hcId, new Function<T, JNIMethod<T>>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public JNIMethod<T> apply(T id) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (InternalError ie) {
            if (inExceptionHandler.get() != Boolean.TRUE) {
                inExceptionHandler.set(true);
                try {
                    JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, new Class[0]);
                }
                finally {
                    inExceptionHandler.remove();
                }
            }
            throw ie;
        }
    }

    private JNI.JClass peer(JNI.JNIEnv env) {
        if (this.peer.isNull()) {
            this.peer = this.resolvePeer(env);
        }
        return this.peer;
    }

    public static boolean isHotSpotCall(StackTraceElement frame) {
        boolean res = FromLibGraalCalls.isHotSpotCallImpl(frame);
        return res;
    }

    private static boolean isHotSpotCallImpl(StackTraceElement frame) {
        if (!FromLibGraalCalls.class.getName().equals(frame.getClassName())) {
            return false;
        }
        return HotSpotCallNames.contains(frame.getMethodName());
    }

    static /* synthetic */ JNI.JClass access$000(FromLibGraalCalls x0, JNI.JNIEnv x1) {
        return x0.peer(x1);
    }

    static {
        HashMap<String, Method> entryPoints = new HashMap<String, Method>();
        HashMap<String, Method> others = new HashMap<String, Method>();
        for (Method m : FromLibGraalCalls.class.getDeclaredMethods()) {
            if (m.getAnnotation(HotSpotCall.class) != null) {
                Method existing = entryPoints.put(m.getName(), m);
                if (existing == null) continue;
                throw new InternalError("Method annotated by " + HotSpotCall.class.getSimpleName() + " must have unique name: " + m + " and " + existing);
            }
            others.put(m.getName(), m);
        }
        for (Map.Entry entry : entryPoints.entrySet()) {
            Method existing = (Method)others.get(entry.getKey());
            if (existing == null) continue;
            throw new InternalError("Method annotated by " + HotSpotCall.class.getSimpleName() + " must have unique name: " + entry.getValue() + " and " + existing);
        }
        HotSpotCallNames = Collections.unmodifiableSet(entryPoints.keySet());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    private static @interface HotSpotCall {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class JNIMethod<T extends Enum<T>> {
        final T hcId;
        final JNI.JMethodID jniId;

        JNIMethod(T hcId, JNI.JMethodID jniId) {
            this.hcId = hcId;
            this.jniId = jniId;
        }

        public String toString() {
            return this.hcId + "[0x" + Long.toHexString(this.jniId.rawValue()) + ']';
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class JNIClass {
        final String className;
        final JNI.JClass jclass;

        JNIClass(String className, JNI.JClass clazz) {
            this.className = className;
            this.jclass = clazz;
        }
    }
}

