/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.word;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SignedDivNode;
import org.graalvm.compiler.nodes.calc.SignedRemNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedDivNode;
import org.graalvm.compiler.nodes.calc.UnsignedRemNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.word.HostedWord;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;
import org.graalvm.word.impl.WordBoxFactory;
import sun.misc.Unsafe;

public abstract class Word
implements SignedWord,
UnsignedWord,
Pointer {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();

    public static void ensureInitialized() {
    }

    private static <T extends WordBase> T box(long val) {
        return (T)HostedWord.boxLong(val);
    }

    protected abstract long unbox();

    private static Word intParam(int val) {
        return (Word)Word.box(val);
    }

    @Operation(opcode=Opcode.TO_RAW_VALUE)
    public long rawValue() {
        return this.unbox();
    }

    @Operation(opcode=Opcode.OBJECT_TO_TRACKED)
    public static native Word objectToTrackedPointer(Object var0);

    @Operation(opcode=Opcode.OBJECT_TO_UNTRACKED)
    public static native Word objectToUntrackedPointer(Object var0);

    @Operation(opcode=Opcode.FROM_ADDRESS)
    public static native Word fromAddress(AddressNode.Address var0);

    @Operation(opcode=Opcode.TO_OBJECT)
    public native Object toObject();

    @Operation(opcode=Opcode.TO_OBJECT_NON_NULL)
    public native Object toObjectNonNull();

    @Operation(node=AddNode.class)
    public Word add(SignedWord val) {
        return this.add((Word)val);
    }

    @Operation(node=AddNode.class)
    public Word add(UnsignedWord val) {
        return this.add((Word)val);
    }

    @Operation(node=AddNode.class)
    public Word add(int val) {
        return this.add(Word.intParam(val));
    }

    @Operation(node=AddNode.class)
    public Word add(Word val) {
        return (Word)Word.box(this.unbox() + val.unbox());
    }

    @Operation(node=SubNode.class)
    public Word subtract(SignedWord val) {
        return this.subtract((Word)val);
    }

    @Operation(node=SubNode.class)
    public Word subtract(UnsignedWord val) {
        return this.subtract((Word)val);
    }

    @Operation(node=SubNode.class)
    public Word subtract(int val) {
        return this.subtract(Word.intParam(val));
    }

    @Operation(node=SubNode.class)
    public Word subtract(Word val) {
        return (Word)Word.box(this.unbox() - val.unbox());
    }

    @Operation(node=MulNode.class)
    public Word multiply(SignedWord val) {
        return this.multiply((Word)val);
    }

    @Operation(node=MulNode.class)
    public Word multiply(UnsignedWord val) {
        return this.multiply((Word)val);
    }

    @Operation(node=MulNode.class)
    public Word multiply(int val) {
        return this.multiply(Word.intParam(val));
    }

    @Operation(node=MulNode.class)
    public Word multiply(Word val) {
        return (Word)Word.box(this.unbox() * val.unbox());
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=SignedDivNode.class)
    public Word signedDivide(SignedWord val) {
        return this.signedDivide((Word)val);
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=SignedDivNode.class)
    public Word signedDivide(int val) {
        return this.signedDivide(Word.intParam(val));
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=SignedDivNode.class)
    public Word signedDivide(Word val) {
        return (Word)Word.box(this.unbox() / val.unbox());
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=UnsignedDivNode.class)
    public Word unsignedDivide(UnsignedWord val) {
        return this.unsignedDivide((Word)val);
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=UnsignedDivNode.class)
    public Word unsignedDivide(int val) {
        return this.signedDivide(Word.intParam(val));
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=UnsignedDivNode.class)
    public Word unsignedDivide(Word val) {
        return (Word)Word.box(Long.divideUnsigned(this.unbox(), val.unbox()));
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=SignedRemNode.class)
    public Word signedRemainder(SignedWord val) {
        return this.signedRemainder((Word)val);
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=SignedRemNode.class)
    public Word signedRemainder(int val) {
        return this.signedRemainder(Word.intParam(val));
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=SignedRemNode.class)
    public Word signedRemainder(Word val) {
        return (Word)Word.box(this.unbox() % val.unbox());
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=UnsignedRemNode.class)
    public Word unsignedRemainder(UnsignedWord val) {
        return this.unsignedRemainder((Word)val);
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=UnsignedRemNode.class)
    public Word unsignedRemainder(int val) {
        return this.signedRemainder(Word.intParam(val));
    }

    @Operation(opcode=Opcode.NODE_CLASS_WITH_GUARD, node=UnsignedRemNode.class)
    public Word unsignedRemainder(Word val) {
        return (Word)Word.box(Long.remainderUnsigned(this.unbox(), val.unbox()));
    }

    @Operation(node=LeftShiftNode.class, rightOperandIsInt=true)
    public Word shiftLeft(UnsignedWord val) {
        return this.shiftLeft((Word)val);
    }

    @Operation(node=LeftShiftNode.class, rightOperandIsInt=true)
    public Word shiftLeft(int val) {
        return this.shiftLeft(Word.intParam(val));
    }

    @Operation(node=LeftShiftNode.class, rightOperandIsInt=true)
    public Word shiftLeft(Word val) {
        return (Word)Word.box(this.unbox() << (int)val.unbox());
    }

    @Operation(node=RightShiftNode.class, rightOperandIsInt=true)
    public Word signedShiftRight(UnsignedWord val) {
        return this.signedShiftRight((Word)val);
    }

    @Operation(node=RightShiftNode.class, rightOperandIsInt=true)
    public Word signedShiftRight(int val) {
        return this.signedShiftRight(Word.intParam(val));
    }

    @Operation(node=RightShiftNode.class, rightOperandIsInt=true)
    public Word signedShiftRight(Word val) {
        return (Word)Word.box(this.unbox() >> (int)val.unbox());
    }

    @Operation(node=UnsignedRightShiftNode.class, rightOperandIsInt=true)
    public Word unsignedShiftRight(UnsignedWord val) {
        return this.unsignedShiftRight((Word)val);
    }

    @Operation(node=UnsignedRightShiftNode.class, rightOperandIsInt=true)
    public Word unsignedShiftRight(int val) {
        return this.unsignedShiftRight(Word.intParam(val));
    }

    @Operation(node=UnsignedRightShiftNode.class, rightOperandIsInt=true)
    public Word unsignedShiftRight(Word val) {
        return (Word)Word.box(this.unbox() >>> (int)val.unbox());
    }

    @Operation(node=AndNode.class)
    public Word and(SignedWord val) {
        return this.and((Word)val);
    }

    @Operation(node=AndNode.class)
    public Word and(UnsignedWord val) {
        return this.and((Word)val);
    }

    @Operation(node=AndNode.class)
    public Word and(int val) {
        return this.and(Word.intParam(val));
    }

    @Operation(node=AndNode.class)
    public Word and(Word val) {
        return (Word)Word.box(this.unbox() & val.unbox());
    }

    @Operation(node=OrNode.class)
    public Word or(SignedWord val) {
        return this.or((Word)val);
    }

    @Operation(node=OrNode.class)
    public Word or(UnsignedWord val) {
        return this.or((Word)val);
    }

    @Operation(node=OrNode.class)
    public Word or(int val) {
        return this.or(Word.intParam(val));
    }

    @Operation(node=OrNode.class)
    public Word or(Word val) {
        return (Word)Word.box(this.unbox() | val.unbox());
    }

    @Operation(node=XorNode.class)
    public Word xor(SignedWord val) {
        return this.xor((Word)val);
    }

    @Operation(node=XorNode.class)
    public Word xor(UnsignedWord val) {
        return this.xor((Word)val);
    }

    @Operation(node=XorNode.class)
    public Word xor(int val) {
        return this.xor(Word.intParam(val));
    }

    @Operation(node=XorNode.class)
    public Word xor(Word val) {
        return (Word)Word.box(this.unbox() ^ val.unbox());
    }

    @Operation(opcode=Opcode.NOT)
    public Word not() {
        return (Word)Word.box(this.unbox() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Operation(opcode=Opcode.IS_NULL)
    public boolean isNull() {
        return this.equal((Word)WordFactory.zero());
    }

    @Operation(opcode=Opcode.IS_NON_NULL)
    public boolean isNonNull() {
        return this.notEqual((Word)WordFactory.zero());
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.EQ)
    public boolean equal(ComparableWord val) {
        return this.equal((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.EQ)
    public boolean equal(SignedWord val) {
        return this.equal((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.EQ)
    public boolean equal(UnsignedWord val) {
        return this.equal((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.EQ)
    public boolean equal(int val) {
        return this.equal(Word.intParam(val));
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.EQ)
    public boolean equal(Word val) {
        return this.unbox() == val.unbox();
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.NE)
    public boolean notEqual(ComparableWord val) {
        return this.notEqual((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.NE)
    public boolean notEqual(SignedWord val) {
        return this.notEqual((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.NE)
    public boolean notEqual(UnsignedWord val) {
        return this.notEqual((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.NE)
    public boolean notEqual(int val) {
        return this.notEqual(Word.intParam(val));
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.NE)
    public boolean notEqual(Word val) {
        return this.unbox() != val.unbox();
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.LT)
    public boolean lessThan(SignedWord val) {
        return this.lessThan((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.LT)
    public boolean lessThan(int val) {
        return this.lessThan(Word.intParam(val));
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.LT)
    public boolean lessThan(Word val) {
        return this.unbox() < val.unbox();
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.LE)
    public boolean lessOrEqual(SignedWord val) {
        return this.lessOrEqual((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.LE)
    public boolean lessOrEqual(int val) {
        return this.lessOrEqual(Word.intParam(val));
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.LE)
    public boolean lessOrEqual(Word val) {
        return this.unbox() <= val.unbox();
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.GT)
    public boolean greaterThan(SignedWord val) {
        return this.greaterThan((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.GT)
    public boolean greaterThan(int val) {
        return this.greaterThan(Word.intParam(val));
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.GT)
    public boolean greaterThan(Word val) {
        return this.unbox() > val.unbox();
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.GE)
    public boolean greaterOrEqual(SignedWord val) {
        return this.greaterOrEqual((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.GE)
    public boolean greaterOrEqual(int val) {
        return this.greaterOrEqual(Word.intParam(val));
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.GE)
    public boolean greaterOrEqual(Word val) {
        return this.unbox() >= val.unbox();
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.BT)
    public boolean belowThan(UnsignedWord val) {
        return this.belowThan((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.BT)
    public boolean belowThan(int val) {
        return this.belowThan(Word.intParam(val));
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.BT)
    public boolean belowThan(Word val) {
        return UnsignedMath.belowThan(this.unbox(), val.unbox());
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.BE)
    public boolean belowOrEqual(UnsignedWord val) {
        return this.belowOrEqual((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.BE)
    public boolean belowOrEqual(int val) {
        return this.belowOrEqual(Word.intParam(val));
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.BE)
    public boolean belowOrEqual(Word val) {
        return UnsignedMath.belowOrEqual(this.unbox(), val.unbox());
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.AT)
    public boolean aboveThan(UnsignedWord val) {
        return this.aboveThan((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.AT)
    public boolean aboveThan(int val) {
        return this.aboveThan(Word.intParam(val));
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.AT)
    public boolean aboveThan(Word val) {
        return UnsignedMath.aboveThan(this.unbox(), val.unbox());
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.AE)
    public boolean aboveOrEqual(UnsignedWord val) {
        return this.aboveOrEqual((Word)val);
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.AE)
    public boolean aboveOrEqual(int val) {
        return this.aboveOrEqual(Word.intParam(val));
    }

    @Operation(opcode=Opcode.COMPARISON, condition=Condition.AE)
    public boolean aboveOrEqual(Word val) {
        return UnsignedMath.aboveOrEqual(this.unbox(), val.unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public byte readByte(WordBase offset, LocationIdentity locationIdentity) {
        return UNSAFE.getByte(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public char readChar(WordBase offset, LocationIdentity locationIdentity) {
        return UNSAFE.getChar(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public short readShort(WordBase offset, LocationIdentity locationIdentity) {
        return UNSAFE.getShort(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public int readInt(WordBase offset, LocationIdentity locationIdentity) {
        return UNSAFE.getInt(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public long readLong(WordBase offset, LocationIdentity locationIdentity) {
        return UNSAFE.getLong(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public float readFloat(WordBase offset, LocationIdentity locationIdentity) {
        return UNSAFE.getFloat(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public double readDouble(WordBase offset, LocationIdentity locationIdentity) {
        return UNSAFE.getDouble(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public <T extends WordBase> T readWord(WordBase offset, LocationIdentity locationIdentity) {
        return Word.box(UNSAFE.getAddress(this.add((Word)offset).unbox()));
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public native Object readObject(WordBase var1, LocationIdentity var2);

    @Operation(opcode=Opcode.READ_POINTER)
    public byte readByte(int offset, LocationIdentity locationIdentity) {
        return this.readByte((WordBase)WordFactory.signed((int)offset), locationIdentity);
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public char readChar(int offset, LocationIdentity locationIdentity) {
        return this.readChar((WordBase)WordFactory.signed((int)offset), locationIdentity);
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public short readShort(int offset, LocationIdentity locationIdentity) {
        return this.readShort((WordBase)WordFactory.signed((int)offset), locationIdentity);
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public int readInt(int offset, LocationIdentity locationIdentity) {
        return this.readInt((WordBase)WordFactory.signed((int)offset), locationIdentity);
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public long readLong(int offset, LocationIdentity locationIdentity) {
        return this.readLong((WordBase)WordFactory.signed((int)offset), locationIdentity);
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public float readFloat(int offset, LocationIdentity locationIdentity) {
        return this.readFloat((WordBase)WordFactory.signed((int)offset), locationIdentity);
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public double readDouble(int offset, LocationIdentity locationIdentity) {
        return this.readDouble((WordBase)WordFactory.signed((int)offset), locationIdentity);
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public <T extends WordBase> T readWord(int offset, LocationIdentity locationIdentity) {
        return this.readWord((WordBase)WordFactory.signed((int)offset), locationIdentity);
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public Object readObject(int offset, LocationIdentity locationIdentity) {
        return this.readObject((WordBase)WordFactory.signed((int)offset), locationIdentity);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeByte(WordBase offset, byte val, LocationIdentity locationIdentity) {
        UNSAFE.putByte(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeChar(WordBase offset, char val, LocationIdentity locationIdentity) {
        UNSAFE.putChar(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeShort(WordBase offset, short val, LocationIdentity locationIdentity) {
        UNSAFE.putShort(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeInt(WordBase offset, int val, LocationIdentity locationIdentity) {
        UNSAFE.putInt(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeLong(WordBase offset, long val, LocationIdentity locationIdentity) {
        UNSAFE.putLong(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeFloat(WordBase offset, float val, LocationIdentity locationIdentity) {
        UNSAFE.putFloat(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeDouble(WordBase offset, double val, LocationIdentity locationIdentity) {
        UNSAFE.putDouble(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeWord(WordBase offset, WordBase val, LocationIdentity locationIdentity) {
        UNSAFE.putAddress(this.add((Word)offset).unbox(), ((Word)val).unbox());
    }

    @Operation(opcode=Opcode.INITIALIZE)
    public void initializeLong(WordBase offset, long val, LocationIdentity locationIdentity) {
        UNSAFE.putLong(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public native void writeObject(WordBase var1, Object var2, LocationIdentity var3);

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeByte(int offset, byte val, LocationIdentity locationIdentity) {
        this.writeByte((WordBase)WordFactory.signed((int)offset), val, locationIdentity);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeChar(int offset, char val, LocationIdentity locationIdentity) {
        this.writeChar((WordBase)WordFactory.signed((int)offset), val, locationIdentity);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeShort(int offset, short val, LocationIdentity locationIdentity) {
        this.writeShort((WordBase)WordFactory.signed((int)offset), val, locationIdentity);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeInt(int offset, int val, LocationIdentity locationIdentity) {
        this.writeInt((WordBase)WordFactory.signed((int)offset), val, locationIdentity);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeLong(int offset, long val, LocationIdentity locationIdentity) {
        this.writeLong((WordBase)WordFactory.signed((int)offset), val, locationIdentity);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeFloat(int offset, float val, LocationIdentity locationIdentity) {
        this.writeFloat((WordBase)WordFactory.signed((int)offset), val, locationIdentity);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeDouble(int offset, double val, LocationIdentity locationIdentity) {
        this.writeDouble((WordBase)WordFactory.signed((int)offset), val, locationIdentity);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeWord(int offset, WordBase val, LocationIdentity locationIdentity) {
        this.writeWord((WordBase)WordFactory.signed((int)offset), val, locationIdentity);
    }

    @Operation(opcode=Opcode.INITIALIZE)
    public void initializeLong(int offset, long val, LocationIdentity locationIdentity) {
        this.initializeLong((WordBase)WordFactory.signed((int)offset), val, locationIdentity);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeObject(int offset, Object val, LocationIdentity locationIdentity) {
        this.writeObject((WordBase)WordFactory.signed((int)offset), val, locationIdentity);
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public byte readByte(WordBase offset) {
        return UNSAFE.getByte(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public char readChar(WordBase offset) {
        return UNSAFE.getChar(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public short readShort(WordBase offset) {
        return UNSAFE.getShort(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public int readInt(WordBase offset) {
        return UNSAFE.getInt(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public long readLong(WordBase offset) {
        return UNSAFE.getLong(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public float readFloat(WordBase offset) {
        return UNSAFE.getFloat(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public double readDouble(WordBase offset) {
        return UNSAFE.getDouble(this.add((Word)offset).unbox());
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public <T extends WordBase> T readWord(WordBase offset) {
        return Word.box(UNSAFE.getAddress(this.add((Word)offset).unbox()));
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public native Object readObject(WordBase var1);

    @Operation(opcode=Opcode.READ_HEAP)
    public native Object readObject(WordBase var1, OnHeapMemoryAccess.BarrierType var2);

    @Operation(opcode=Opcode.READ_HEAP)
    public native Object readObject(WordBase var1, OnHeapMemoryAccess.BarrierType var2, LocationIdentity var3);

    @Operation(opcode=Opcode.READ_POINTER)
    public byte readByte(int offset) {
        return this.readByte((WordBase)WordFactory.signed((int)offset));
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public char readChar(int offset) {
        return this.readChar((WordBase)WordFactory.signed((int)offset));
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public short readShort(int offset) {
        return this.readShort((WordBase)WordFactory.signed((int)offset));
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public int readInt(int offset) {
        return this.readInt((WordBase)WordFactory.signed((int)offset));
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public long readLong(int offset) {
        return this.readLong((WordBase)WordFactory.signed((int)offset));
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public float readFloat(int offset) {
        return this.readFloat((WordBase)WordFactory.signed((int)offset));
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public double readDouble(int offset) {
        return this.readDouble((WordBase)WordFactory.signed((int)offset));
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public <T extends WordBase> T readWord(int offset) {
        return this.readWord((WordBase)WordFactory.signed((int)offset));
    }

    @Operation(opcode=Opcode.READ_POINTER)
    public Object readObject(int offset) {
        return this.readObject((WordBase)WordFactory.signed((int)offset));
    }

    @Operation(opcode=Opcode.READ_HEAP)
    public Object readObject(int offset, OnHeapMemoryAccess.BarrierType barrierType) {
        return this.readObject((WordBase)WordFactory.signed((int)offset), barrierType);
    }

    @Operation(opcode=Opcode.READ_HEAP)
    public Object readObject(int offset, OnHeapMemoryAccess.BarrierType barrierType, LocationIdentity locationIdentity) {
        return this.readObject((WordBase)WordFactory.signed((int)offset), barrierType, locationIdentity);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeByte(WordBase offset, byte val) {
        UNSAFE.putByte(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeChar(WordBase offset, char val) {
        UNSAFE.putChar(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeShort(WordBase offset, short val) {
        UNSAFE.putShort(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeInt(WordBase offset, int val) {
        UNSAFE.putInt(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeLong(WordBase offset, long val) {
        UNSAFE.putLong(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeFloat(WordBase offset, float val) {
        UNSAFE.putFloat(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeDouble(WordBase offset, double val) {
        UNSAFE.putDouble(this.add((Word)offset).unbox(), val);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public native int compareAndSwapInt(WordBase var1, int var2, int var3, LocationIdentity var4);

    @Operation(opcode=Opcode.CAS_POINTER)
    public native long compareAndSwapLong(WordBase var1, long var2, long var4, LocationIdentity var6);

    @Operation(opcode=Opcode.CAS_POINTER)
    public native <T extends WordBase> T compareAndSwapWord(WordBase var1, T var2, T var3, LocationIdentity var4);

    @Operation(opcode=Opcode.CAS_POINTER)
    public native Object compareAndSwapObject(WordBase var1, Object var2, Object var3, LocationIdentity var4);

    @Operation(opcode=Opcode.CAS_POINTER)
    public boolean logicCompareAndSwapInt(WordBase offset, int expectedValue, int newValue, LocationIdentity locationIdentity) {
        return UNSAFE.compareAndSwapInt(this.toObject(), ((Word)offset).unbox(), expectedValue, newValue);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public boolean logicCompareAndSwapLong(WordBase offset, long expectedValue, long newValue, LocationIdentity locationIdentity) {
        return UNSAFE.compareAndSwapLong(this.toObject(), ((Word)offset).unbox(), expectedValue, newValue);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public native boolean logicCompareAndSwapWord(WordBase var1, WordBase var2, WordBase var3, LocationIdentity var4);

    @Operation(opcode=Opcode.CAS_POINTER)
    public boolean logicCompareAndSwapObject(WordBase offset, Object expectedValue, Object newValue, LocationIdentity locationIdentity) {
        return UNSAFE.compareAndSwapObject(this.toObject(), ((Word)offset).unbox(), expectedValue, newValue);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeWord(WordBase offset, WordBase val) {
        UNSAFE.putAddress(this.add((Word)offset).unbox(), ((Word)val).unbox());
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public native void writeObject(WordBase var1, Object var2);

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeByte(int offset, byte val) {
        this.writeByte((WordBase)WordFactory.signed((int)offset), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeChar(int offset, char val) {
        this.writeChar((WordBase)WordFactory.signed((int)offset), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeShort(int offset, short val) {
        this.writeShort((WordBase)WordFactory.signed((int)offset), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeInt(int offset, int val) {
        this.writeInt((WordBase)WordFactory.signed((int)offset), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeLong(int offset, long val) {
        this.writeLong((WordBase)WordFactory.signed((int)offset), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeFloat(int offset, float val) {
        this.writeFloat((WordBase)WordFactory.signed((int)offset), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeDouble(int offset, double val) {
        this.writeDouble((WordBase)WordFactory.signed((int)offset), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeWord(int offset, WordBase val) {
        this.writeWord((WordBase)WordFactory.signed((int)offset), val);
    }

    @Operation(opcode=Opcode.WRITE_POINTER)
    public void writeObject(int offset, Object val) {
        this.writeObject((WordBase)WordFactory.signed((int)offset), val);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public int compareAndSwapInt(int offset, int expectedValue, int newValue, LocationIdentity locationIdentity) {
        return this.compareAndSwapInt((WordBase)WordFactory.signed((int)offset), expectedValue, newValue, locationIdentity);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public long compareAndSwapLong(int offset, long expectedValue, long newValue, LocationIdentity locationIdentity) {
        return this.compareAndSwapLong((WordBase)WordFactory.signed((int)offset), expectedValue, newValue, locationIdentity);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public <T extends WordBase> T compareAndSwapWord(int offset, T expectedValue, T newValue, LocationIdentity locationIdentity) {
        return this.compareAndSwapWord((WordBase)WordFactory.signed((int)offset), expectedValue, newValue, locationIdentity);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public Object compareAndSwapObject(int offset, Object expectedValue, Object newValue, LocationIdentity locationIdentity) {
        return this.compareAndSwapObject((WordBase)WordFactory.signed((int)offset), expectedValue, newValue, locationIdentity);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public boolean logicCompareAndSwapInt(int offset, int expectedValue, int newValue, LocationIdentity locationIdentity) {
        return this.logicCompareAndSwapInt((WordBase)WordFactory.signed((int)offset), expectedValue, newValue, locationIdentity);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public boolean logicCompareAndSwapLong(int offset, long expectedValue, long newValue, LocationIdentity locationIdentity) {
        return this.logicCompareAndSwapLong((WordBase)WordFactory.signed((int)offset), expectedValue, newValue, locationIdentity);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public boolean logicCompareAndSwapWord(int offset, WordBase expectedValue, WordBase newValue, LocationIdentity locationIdentity) {
        return this.logicCompareAndSwapWord((WordBase)WordFactory.signed((int)offset), expectedValue, newValue, locationIdentity);
    }

    @Operation(opcode=Opcode.CAS_POINTER)
    public boolean logicCompareAndSwapObject(int offset, Object expectedValue, Object newValue, LocationIdentity locationIdentity) {
        return this.logicCompareAndSwapObject((WordBase)WordFactory.signed((int)offset), expectedValue, newValue, locationIdentity);
    }

    @Deprecated
    public final boolean equals(Object obj) {
        throw GraalError.shouldNotReachHere("equals must not be called on words");
    }

    public final int hashCode() {
        throw GraalError.shouldNotReachHere("hashCode must not be called on words");
    }

    public String toString() {
        throw GraalError.shouldNotReachHere("toString must not be called on words");
    }

    static {
        BoxFactoryImpl.initialize();
    }

    static class BoxFactoryImpl
    extends WordBoxFactory {
        BoxFactoryImpl() {
        }

        static void initialize() {
            assert (boxFactory == null) : "BoxFactory must be initialized only once.";
            boxFactory = new BoxFactoryImpl();
        }

        public <T extends WordBase> T boxImpl(long val) {
            return (T)HostedWord.boxLong(val);
        }
    }

    public static enum Opcode {
        NODE_CLASS,
        NODE_CLASS_WITH_GUARD,
        COMPARISON,
        IS_NULL,
        IS_NON_NULL,
        NOT,
        READ_POINTER,
        READ_OBJECT,
        READ_BARRIERED,
        READ_HEAP,
        WRITE_POINTER,
        WRITE_POINTER_SIDE_EFFECT_FREE,
        WRITE_OBJECT,
        WRITE_BARRIERED,
        CAS_POINTER,
        INITIALIZE,
        FROM_ADDRESS,
        OBJECT_TO_TRACKED,
        OBJECT_TO_UNTRACKED,
        TO_OBJECT,
        TO_OBJECT_NON_NULL,
        TO_RAW_VALUE;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Operation {
        public Class<? extends ValueNode> node() default ValueNode.class;

        public boolean rightOperandIsInt() default false;

        public Opcode opcode() default Opcode.NODE_CLASS;

        public Condition condition() default Condition.EQ;
    }
}

