/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import java.util.Map;
import java.util.function.Supplier;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.IgvSupport;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalTruffleCompilation;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.TruffleToLibGraalCalls;
import org.graalvm.libgraal.LibGraalObject;
import org.graalvm.libgraal.LibGraalScope;
import org.graalvm.util.OptionsEncoder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class LibGraalHotSpotTruffleCompiler
implements HotSpotTruffleCompiler {
    private final ThreadLocal<LibGraalTruffleCompilation> activeCompilation = new ThreadLocal();
    private final LibGraalTruffleRuntime runtime;
    Integer pendingTransferToInterpreterOffset;

    private long handle(Supplier<Map<String, Object>> optionsSupplier, CompilableTruffleAST compilable, boolean firstInitialization) {
        return LibGraalHotSpotTruffleCompiler.handleImpl(() -> {
            long isolateThread = LibGraalScope.getIsolateThread();
            long compilerHandle = TruffleToLibGraalCalls.newCompiler(isolateThread, this.runtime.handle());
            TruffleToLibGraalCalls.initializeCompiler(isolateThread, compilerHandle, OptionsEncoder.encode((Map)optionsSupplier.get()), compilable, firstInitialization);
            return new Handle(compilerHandle);
        });
    }

    private static long handle() {
        return LibGraalHotSpotTruffleCompiler.handleImpl(() -> {
            throw new IllegalStateException("Handle not yet created. Missing call of the TruffleCompiler::initialize method or calling compiler method outside of the compiler thread scope.");
        });
    }

    long handle(Map<String, Object> options, LibGraalTruffleCompilation compilation) {
        return this.handle(() -> options, compilation != null ? compilation.getCompilable() : null, false);
    }

    private static long handleImpl(Supplier<Handle> handleSupplier) {
        try (LibGraalScope scope = new LibGraalScope();){
            long l = scope.getIsolate().getSingleton(Handle.class, handleSupplier).getHandle();
            return l;
        }
    }

    LibGraalHotSpotTruffleCompiler(LibGraalTruffleRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public void initialize(Map<String, Object> options, CompilableTruffleAST compilable, boolean firstInitialization) {
        this.handle(() -> options, compilable, firstInitialization);
    }

    @Override
    public TruffleCompilation openCompilation(CompilableTruffleAST compilable) {
        LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);
        long compilationHandle = TruffleToLibGraalCalls.openCompilation(LibGraalScope.getIsolateThread(), this.handle(LibGraalHotSpotTruffleCompiler.optionsEncoder(compilable), compilable, false), compilable);
        LibGraalTruffleCompilation compilation = new LibGraalTruffleCompilation(this, compilationHandle, scope);
        this.activeCompilation.set(compilation);
        return compilation;
    }

    @Override
    public TruffleDebugContext openDebugContext(Map<String, Object> options, TruffleCompilation compilation) {
        return IgvSupport.create(this, options, (LibGraalTruffleCompilation)compilation);
    }

    @Override
    public void doCompile(TruffleDebugContext debug, TruffleCompilation compilation, Map<String, Object> options, TruffleMetaAccessProvider inlining, TruffleCompilationTask task, TruffleCompilerListener listener) {
        byte[] encodedOptions = OptionsEncoder.encode(options);
        long debugContextHandle = ((IgvSupport)debug).getHandle();
        long compilationHandle = ((LibGraalTruffleCompilation)compilation).getHandle();
        TruffleToLibGraalCalls.doCompile(LibGraalScope.getIsolateThread(), LibGraalHotSpotTruffleCompiler.handle(), debugContextHandle, compilationHandle, encodedOptions, inlining, task, listener);
    }

    @Override
    public String getCompilerConfigurationName() {
        return this.runtime.initLazyCompilerConfigurationName();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void installTruffleCallBoundaryMethods(CompilableTruffleAST compilable) {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            TruffleToLibGraalCalls.installTruffleCallBoundaryMethods(LibGraalScope.getIsolateThread(), this.handle(LibGraalHotSpotTruffleCompiler.optionsEncoder(compilable), compilable, false), compilable);
        }
    }

    @Override
    public int pendingTransferToInterpreterOffset(CompilableTruffleAST compilable) {
        if (this.pendingTransferToInterpreterOffset == null) {
            try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
                this.pendingTransferToInterpreterOffset = TruffleToLibGraalCalls.pendingTransferToInterpreterOffset(LibGraalScope.getIsolateThread(), this.handle(LibGraalHotSpotTruffleCompiler.optionsEncoder(compilable), compilable, false), compilable);
            }
        }
        return this.pendingTransferToInterpreterOffset;
    }

    void closeCompilation(LibGraalTruffleCompilation compilation) {
        assert (this.activeCompilation.get() == compilation);
        this.activeCompilation.set(null);
    }

    LibGraalTruffleCompilation getActiveCompilation() {
        return this.activeCompilation.get();
    }

    private static Supplier<Map<String, Object>> optionsEncoder(CompilableTruffleAST compilable) {
        return () -> GraalTruffleRuntime.getOptionsForCompiler((OptimizedCallTarget)compilable);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class Handle
    extends LibGraalObject {
        Handle(long handle) {
            super(handle);
        }
    }
}

