/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot;

import com.oracle.truffle.api.nodes.RootNode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotNmethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.hotspot.HotSpotTruffleRuntimeServices;

public class HotSpotOptimizedCallTarget
extends OptimizedCallTarget
implements OptimizedAssumptionDependency {
    private static final InstalledCode INVALID_CODE = new InstalledCode(null);
    private InstalledCode installedCode = INVALID_CODE;

    public HotSpotOptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
        super(sourceCallTarget, rootNode);
    }

    @Override
    public boolean soleExecutionEntryPoint() {
        return true;
    }

    public void setInstalledCode(InstalledCode code) {
        HotSpotNmethod nmethod;
        if (this.installedCode == code) {
            return;
        }
        if (this.installedCode.isAlive()) {
            this.installedCode.invalidate();
            this.onInvalidate(null, null, true);
        }
        if (code instanceof HotSpotNmethod && (nmethod = (HotSpotNmethod)code).isDefault()) {
            throw new IllegalArgumentException("Cannot install a default nmethod for a " + this.getClass().getSimpleName());
        }
        this.installedCode = code;
    }

    @Override
    public CompilableTruffleAST getCompilable() {
        return this;
    }

    @Override
    public boolean isValid() {
        return this.installedCode.isValid();
    }

    @Override
    public boolean isValidLastTier() {
        InstalledCode code = this.installedCode;
        return code.isValid() && code.getName().endsWith("#2");
    }

    @Override
    public long getCodeAddress() {
        return this.installedCode.getAddress();
    }

    @Override
    public void onAssumptionInvalidated(Object source, CharSequence reason) {
        boolean wasAlive = false;
        if (this.installedCode.isAlive()) {
            this.installedCode.invalidate();
            wasAlive = true;
        }
        this.onInvalidate(source, reason, wasAlive);
    }

    @Override
    public SpeculationLog getCompilationSpeculationLog() {
        return HotSpotTruffleRuntimeServices.getCompilationSpeculationLog(this);
    }
}

