/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeVisitor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Level;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

public final class StatisticsListener
extends AbstractGraalTruffleRuntimeListener {
    private long firstCompilation;
    private int compilations;
    private int invalidations;
    private int failures;
    private int temporaryBailouts;
    private int permanentBailouts;
    private int success;
    private int queues;
    private int dequeues;
    private int splits;
    private final IdentityStatistics<String> temporaryBailoutReasons = new IdentityStatistics();
    private final IdentityStatistics<String> permanentBailoutReasons = new IdentityStatistics();
    private final IdentityStatistics<String> failureReasons = new IdentityStatistics();
    private final IdentityStatistics<String> invalidatedReasons = new IdentityStatistics();
    private final IdentityStatistics<String> dequeuedReasons = new IdentityStatistics();
    private final TargetLongStatistics timeToQueue = new TargetLongStatistics();
    private final TargetLongStatistics timeInQueue = new TargetLongStatistics();
    private final TargetIntStatistics nodeCount = new TargetIntStatistics();
    private final TargetIntStatistics nodeCountTrivial = new TargetIntStatistics();
    private final TargetIntStatistics nodeCountNonTrivial = new TargetIntStatistics();
    private final TargetIntStatistics nodeCountMonomorphic = new TargetIntStatistics();
    private final TargetIntStatistics nodeCountPolymorphic = new TargetIntStatistics();
    private final TargetIntStatistics nodeCountMegamorphic = new TargetIntStatistics();
    private final IdentityStatistics<Class<?>> nodeStatistics = new IdentityStatistics();
    private final TargetIntStatistics callCount = new TargetIntStatistics();
    private final TargetIntStatistics callCountIndirect = new TargetIntStatistics();
    private final TargetIntStatistics callCountDirect = new TargetIntStatistics();
    private final TargetIntStatistics callCountDirectDispatched = new TargetIntStatistics();
    private final TargetIntStatistics callCountDirectInlined = new TargetIntStatistics();
    private final TargetIntStatistics callCountDirectCloned = new TargetIntStatistics();
    private final TargetIntStatistics callCountDirectNotCloned = new TargetIntStatistics();
    private final TargetIntStatistics loopCount = new TargetIntStatistics();
    private final TargetLongStatistics compilationTime = new TargetLongStatistics();
    private final TargetLongStatistics compilationTimeTruffleTier = new TargetLongStatistics();
    private final TargetLongStatistics compilationTimeGraalTier = new TargetLongStatistics();
    private final TargetLongStatistics compilationTimeCodeInstallation = new TargetLongStatistics();
    private final TargetIntStatistics truffleTierNodeCount = new TargetIntStatistics();
    private final IdentityStatistics<String> truffleTierNodeStatistics = new IdentityStatistics();
    private final TargetIntStatistics graalTierNodeCount = new TargetIntStatistics();
    private final IdentityStatistics<String> graalTierNodeStatistics = new IdentityStatistics();
    private final TargetIntStatistics compilationResultCodeSize = new TargetIntStatistics();
    private final TargetIntStatistics compilationResultExceptionHandlers = new TargetIntStatistics();
    private final TargetIntStatistics compilationResultInfopoints = new TargetIntStatistics();
    private final IdentityStatistics<String> compilationResultInfopointStatistics = new IdentityStatistics();
    private final TargetIntStatistics compilationResultMarks = new TargetIntStatistics();
    private final TargetIntStatistics compilationResultTotalFrameSize = new TargetIntStatistics();
    private final TargetIntStatistics compilationResultDataPatches = new TargetIntStatistics();
    private final Map<OptimizedCallTarget, Long> timeQueued = new HashMap<OptimizedCallTarget, Long>();
    private final ThreadLocal<Times> compilationTimes = new ThreadLocal();

    private StatisticsListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new StatisticsDispatcher(runtime));
    }

    public static StatisticsListener createEngineListener(GraalTruffleRuntime runtime) {
        return new StatisticsListener(runtime);
    }

    @Override
    public synchronized void onCompilationSplit(OptimizedDirectCallNode callNode) {
        ++this.splits;
    }

    @Override
    public synchronized void onCompilationQueued(OptimizedCallTarget target, int tier) {
        ++this.queues;
        long currentTime = System.nanoTime();
        if (this.firstCompilation == 0L) {
            this.firstCompilation = currentTime;
        }
        this.timeQueued.put(target, currentTime);
        long timeStamp = target.getInitializedTimestamp();
        if (timeStamp != 0L) {
            this.timeToQueue.accept(currentTime - timeStamp, target);
        }
    }

    @Override
    public synchronized void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason, int tier) {
        ++this.dequeues;
        this.dequeuedReasons.accept(Arrays.asList(Objects.toString(reason)), target);
        this.timeQueued.remove(target);
    }

    @Override
    public synchronized void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        ++this.invalidations;
        this.invalidatedReasons.accept(Arrays.asList(Objects.toString(reason)), target);
    }

    @Override
    public synchronized void onCompilationStarted(OptimizedCallTarget target, int tier) {
        ++this.compilations;
        Times times = new Times();
        this.compilationTimes.set(times);
        Long timeStamp = this.timeQueued.get(target);
        if (timeStamp != null) {
            this.timeInQueue.accept(times.compilationStarted - timeStamp, target);
        }
        this.timeQueued.remove(target);
    }

    @Override
    public synchronized void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
        Times times = this.compilationTimes.get();
        times.truffleTierFinished = System.nanoTime();
        this.nodeStatistics.accept(StatisticsListener.nodeClasses(inliningDecision), target);
        CallTargetNodeStatistics callTargetStat = new CallTargetNodeStatistics(inliningDecision);
        this.nodeCount.accept(callTargetStat.getNodeCount(), target);
        this.nodeCountTrivial.accept(callTargetStat.getNodeCountTrivial(), target);
        this.nodeCountNonTrivial.accept(callTargetStat.getNodeCountNonTrivial(), target);
        this.nodeCountMonomorphic.accept(callTargetStat.getNodeCountMonomorphic(), target);
        this.nodeCountPolymorphic.accept(callTargetStat.getNodeCountPolymorphic(), target);
        this.nodeCountMegamorphic.accept(callTargetStat.getNodeCountMegamorphic(), target);
        this.callCount.accept(callTargetStat.getCallCount(), target);
        this.callCountIndirect.accept(callTargetStat.getCallCountIndirect(), target);
        this.callCountDirect.accept(callTargetStat.getCallCountDirect(), target);
        this.callCountDirectDispatched.accept(callTargetStat.getCallCountDirectDispatched(), target);
        this.callCountDirectInlined.accept(callTargetStat.getCallCountDirectInlined(), target);
        this.callCountDirectCloned.accept(callTargetStat.getCallCountDirectCloned(), target);
        this.callCountDirectNotCloned.accept(callTargetStat.getCallCountDirectNotCloned(), target);
        this.loopCount.accept(callTargetStat.getLoopCount(), target);
        this.truffleTierNodeCount.accept(graph.getNodeCount(), target);
        if (target.engine.callTargetStatisticDetails) {
            this.truffleTierNodeStatistics.accept(Arrays.asList(graph.getNodeTypes(true)), target);
        }
    }

    private static Collection<Class<?>> nodeClasses(TruffleInlining inliningDecision) {
        final ArrayList nodeClasses = new ArrayList();
        for (CompilableTruffleAST ast : inliningDecision.inlinedTargets()) {
            ((OptimizedCallTarget)ast).accept(new NodeVisitor(){

                public boolean visit(Node node) {
                    if (node != null) {
                        nodeClasses.add(node.getClass());
                    }
                    return true;
                }
            });
        }
        return nodeClasses;
    }

    @Override
    public synchronized void onCompilationGraalTierFinished(OptimizedCallTarget target, TruffleCompilerListener.GraphInfo graph) {
        Times times = this.compilationTimes.get();
        times.graalTierFinished = System.nanoTime();
        this.graalTierNodeCount.accept(graph.getNodeCount(), target);
        if (target.engine.callTargetStatisticDetails) {
            this.graalTierNodeStatistics.accept(Arrays.asList(graph.getNodeTypes(true)), target);
        }
    }

    @Override
    public synchronized void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result, int tier) {
        ++this.success;
        long compilationDone = System.nanoTime();
        Times times = this.compilationTimes.get();
        this.compilationTime.accept(compilationDone - times.compilationStarted, target);
        this.compilationTimeTruffleTier.accept(times.truffleTierFinished - times.compilationStarted, target);
        this.compilationTimeGraalTier.accept(times.graalTierFinished - times.truffleTierFinished, target);
        this.compilationTimeCodeInstallation.accept(compilationDone - times.graalTierFinished, target);
        this.compilationResultCodeSize.accept(result.getTargetCodeSize(), target);
        this.compilationResultTotalFrameSize.accept(result.getTotalFrameSize(), target);
        this.compilationResultExceptionHandlers.accept(result.getExceptionHandlersCount(), target);
        this.compilationResultInfopoints.accept(result.getInfopointsCount(), target);
        this.compilationResultInfopointStatistics.accept(Arrays.asList(result.getInfopoints()), target);
        this.compilationResultMarks.accept(result.getMarksCount(), target);
        this.compilationResultDataPatches.accept(result.getDataPatchesCount(), target);
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout, int tier) {
        if (bailout) {
            if (permanentBailout) {
                ++this.permanentBailouts;
                this.permanentBailoutReasons.accept(Arrays.asList(reason), target);
            } else {
                ++this.temporaryBailouts;
                this.temporaryBailoutReasons.accept(Arrays.asList(reason), target);
            }
        } else {
            ++this.failures;
            this.failureReasons.accept(Arrays.asList(reason), target);
        }
        Times times = this.compilationTimes.get();
        this.compilationTime.accept(System.nanoTime() - times.compilationStarted, target);
    }

    @Override
    public void onEngineClosed(EngineData runtimeData) {
        this.printStatistics(runtimeData);
    }

    private void printStatistics(EngineData runtimeData) {
        GraalTruffleRuntime rt = this.runtime;
        long endTime = System.nanoTime();
        StringWriter logMessage = new StringWriter();
        try (PrintWriter out = new PrintWriter(logMessage);){
            out.print("Truffle runtime statistics for engine " + runtimeData.id);
            StatisticsListener.printStatistic(out, "Compilations", this.compilations);
            StatisticsListener.printStatistic(out, "  Success", this.success);
            StatisticsListener.printStatistic(out, "  Temporary Bailouts", this.temporaryBailouts);
            this.temporaryBailoutReasons.printStatistics(out, String::toString, true, false);
            StatisticsListener.printStatistic(out, "  Permanent Bailouts", this.permanentBailouts);
            this.permanentBailoutReasons.printStatistics(out, String::toString, true, false);
            StatisticsListener.printStatistic(out, "  Failed", this.failures);
            this.failureReasons.printStatistics(out, String::toString, true, false);
            StatisticsListener.printStatistic(out, "  Interrupted", this.compilations - (this.success + this.failures + this.temporaryBailouts + this.permanentBailouts));
            StatisticsListener.printStatistic(out, "Invalidated", this.invalidations);
            this.invalidatedReasons.printStatistics(out, String::toString, true, false);
            StatisticsListener.printStatistic(out, "Queues", this.queues);
            StatisticsListener.printStatistic(out, "Dequeues", this.dequeues);
            this.dequeuedReasons.printStatistics(out, String::toString, true, false);
            StatisticsListener.printStatistic(out, "Splits", this.splits);
            StatisticsListener.printStatistic(out, "Compilation Accuracy", 1.0 - (double)this.invalidations / (double)this.compilations);
            StatisticsListener.printStatistic(out, "Queue Accuracy", 1.0 - (double)this.dequeues / (double)this.queues);
            StatisticsListener.printStatistic(out, "Compilation Utilization", (double)this.compilationTime.getSum() / (double)(endTime - this.firstCompilation));
            StatisticsListener.printStatistic(out, "Remaining Compilation Queue", rt.getCompilationQueueSize());
            StatisticsListener.printStatisticTime(out, "Time to queue", this.timeToQueue);
            StatisticsListener.printStatisticTime(out, "Time waiting in queue", this.timeInQueue);
            StatisticsListener.printStatisticTime(out, "Time for compilation", this.compilationTime);
            StatisticsListener.printStatisticTime(out, "  Truffle Tier", this.compilationTimeTruffleTier);
            StatisticsListener.printStatisticTime(out, "  Graal Tier", this.compilationTimeGraalTier);
            StatisticsListener.printStatisticTime(out, "  Code Installation", this.compilationTimeCodeInstallation);
            StatisticsListener.printStatistic(out, "Truffle node count", this.nodeCount);
            StatisticsListener.printStatistic(out, "  Trivial", this.nodeCountTrivial);
            StatisticsListener.printStatistic(out, "  Non Trivial", this.nodeCountNonTrivial);
            StatisticsListener.printStatistic(out, "    Monomorphic", this.nodeCountMonomorphic);
            StatisticsListener.printStatistic(out, "    Polymorphic", this.nodeCountPolymorphic);
            StatisticsListener.printStatistic(out, "    Megamorphic", this.nodeCountMegamorphic);
            StatisticsListener.printStatistic(out, "Truffle call count", this.callCount);
            StatisticsListener.printStatistic(out, "  Indirect", this.callCountIndirect);
            StatisticsListener.printStatistic(out, "  Direct", this.callCountDirect);
            StatisticsListener.printStatistic(out, "    Dispatched", this.callCountDirectDispatched);
            StatisticsListener.printStatistic(out, "    Inlined", this.callCountDirectInlined);
            StatisticsListener.printStatistic(out, "    ----------");
            StatisticsListener.printStatistic(out, "    Cloned", this.callCountDirectCloned);
            StatisticsListener.printStatistic(out, "    Not Cloned", this.callCountDirectNotCloned);
            StatisticsListener.printStatistic(out, "Truffle loops", this.loopCount);
            StatisticsListener.printStatistic(out, "Graal node count");
            StatisticsListener.printStatistic(out, "  After Truffle Tier", this.truffleTierNodeCount);
            StatisticsListener.printStatistic(out, "  After Graal Tier", this.graalTierNodeCount);
            StatisticsListener.printStatistic(out, "Graal compilation result");
            StatisticsListener.printStatistic(out, "  Code size", this.compilationResultCodeSize);
            StatisticsListener.printStatistic(out, "  Total frame size", this.compilationResultTotalFrameSize);
            StatisticsListener.printStatistic(out, "  Exception handlers", this.compilationResultExceptionHandlers);
            StatisticsListener.printStatistic(out, "  Infopoints", this.compilationResultInfopoints);
            this.compilationResultInfopointStatistics.printStatistics(out, Function.identity(), false, true);
            StatisticsListener.printStatistic(out, "  Marks", this.compilationResultMarks);
            StatisticsListener.printStatistic(out, "  Data references", this.compilationResultDataPatches);
            if (runtimeData.callTargetStatisticDetails) {
                StatisticsListener.printStatistic(out, "Truffle nodes");
                this.nodeStatistics.printStatistics(out, Class::getSimpleName, false, true);
                StatisticsListener.printStatistic(out, "Graal nodes after Truffle tier");
                this.truffleTierNodeStatistics.printStatistics(out, Function.identity(), false, true);
                StatisticsListener.printStatistic(out, "Graal nodes after Graal tier");
                this.graalTierNodeStatistics.printStatistics(out, Function.identity(), false, true);
            }
        }
        TruffleLogger logger = runtimeData.getEngineLogger();
        logger.log(Level.INFO, logMessage.toString());
    }

    private static void printStatistic(PrintWriter out, String label) {
        out.printf("%n  %-50s:", label);
    }

    private static void printStatistic(PrintWriter out, String label, long value) {
        out.printf("%n  %-50s: %d", label, value);
    }

    private static void printStatistic(PrintWriter out, String label, double value) {
        out.printf("%n  %-50s: %f", label, value);
    }

    private static void printStatistic(PrintWriter out, String label, TargetIntStatistics value) {
        out.printf("%n  %-50s: count=%4d, sum=%8d, min=%8d, average=%12.2f, max=%8d, maxTarget=%s", label, value.getCount(), value.getSum(), value.getMin(), value.getAverage(), value.getMax(), value.getMaxName());
    }

    private static void printStatisticTime(PrintWriter out, String label, TargetLongStatistics value) {
        out.printf("%n  %-50s: count=%4d, sum=%8d, min=%8d, average=%12.2f, max=%8d (milliseconds), maxTarget=%s", label, value.getCount(), value.getSum() / 1000000L, value.getMin() / 1000000L, value.getAverage() / 1000000.0, value.getMax() / 1000000L, value.getMaxName());
    }

    private static final class StatisticsDispatcher
    extends AbstractGraalTruffleRuntimeListener {
        private StatisticsDispatcher(GraalTruffleRuntime runtime) {
            super(runtime);
        }

        @Override
        public void onCompilationQueued(OptimizedCallTarget target, int tier) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationQueued(target, tier);
            }
        }

        @Override
        public void onCompilationStarted(OptimizedCallTarget target, int tier) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationStarted(target, tier);
            }
        }

        @Override
        public void onCompilationSplit(OptimizedDirectCallNode callNode) {
            StatisticsListener listener = callNode.getCallTarget().engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationSplit(callNode);
            }
        }

        @Override
        public void onCompilationSplitFailed(OptimizedDirectCallNode callNode, CharSequence reason) {
            StatisticsListener listener = callNode.getCallTarget().engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationSplitFailed(callNode, reason);
            }
        }

        @Override
        public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason, int tier) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationDequeued(target, source, reason, tier);
            }
        }

        @Override
        public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationInvalidated(target, source, reason);
            }
        }

        @Override
        public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationTruffleTierFinished(target, inliningDecision, graph);
            }
        }

        @Override
        public void onCompilationGraalTierFinished(OptimizedCallTarget target, TruffleCompilerListener.GraphInfo graph) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationGraalTierFinished(target, graph);
            }
        }

        @Override
        public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result, int tier) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationSuccess(target, inliningDecision, graph, result, tier);
            }
        }

        @Override
        public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout, int tier) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationFailed(target, reason, bailout, permanentBailout, tier);
            }
        }

        @Override
        public void onEngineClosed(EngineData runtimeData) {
            StatisticsListener listener = runtimeData.statisticsListener;
            if (listener != null) {
                listener.onEngineClosed(runtimeData);
            }
        }
    }

    static class Times {
        final long compilationStarted = System.nanoTime();
        long truffleTierFinished;
        long graalTierFinished;

        Times() {
        }
    }

    private static final class CallTargetNodeStatistics {
        private int nodeCountTrivial;
        private int nodeCountNonTrivial;
        private int nodeCountMonomorphic;
        private int nodeCountPolymorphic;
        private int nodeCountMegamorphic;
        private int callCountIndirect;
        private int callCountDirectDispatched;
        private int callCountDirectInlined;
        private int callCountDirectCloned;
        private int callCountDirectNotCloned;
        private int loopCount;

        CallTargetNodeStatistics(TruffleInlining inliningDecision) {
            for (CompilableTruffleAST ast : inliningDecision.inlinedTargets()) {
                ((OptimizedCallTarget)ast).accept(this::visitNode);
            }
            this.callCountDirectInlined = inliningDecision.countInlinedCalls();
            this.callCountDirectDispatched = inliningDecision.countCalls() - this.callCountDirectInlined;
        }

        private boolean visitNode(Node node) {
            if (node == null) {
                return true;
            }
            NodeCost cost = node.getCost();
            if (cost.isTrivial()) {
                ++this.nodeCountTrivial;
            } else {
                ++this.nodeCountNonTrivial;
                if (cost == NodeCost.MONOMORPHIC) {
                    ++this.nodeCountMonomorphic;
                } else if (cost == NodeCost.POLYMORPHIC) {
                    ++this.nodeCountPolymorphic;
                } else if (cost == NodeCost.MEGAMORPHIC) {
                    ++this.nodeCountMegamorphic;
                }
            }
            if (node instanceof DirectCallNode) {
                OptimizedDirectCallNode optimizedDirectCallNode;
                OptimizedDirectCallNode optimizedDirectCallNode2 = optimizedDirectCallNode = node instanceof OptimizedDirectCallNode ? (OptimizedDirectCallNode)node : null;
                if (optimizedDirectCallNode != null && optimizedDirectCallNode.getCallTarget().isSplit()) {
                    ++this.callCountDirectCloned;
                } else {
                    ++this.callCountDirectNotCloned;
                }
            } else if (node instanceof IndirectCallNode) {
                ++this.callCountIndirect;
            } else if (node instanceof LoopNode) {
                ++this.loopCount;
            }
            return true;
        }

        public int getCallCountDirectCloned() {
            return this.callCountDirectCloned;
        }

        public int getCallCountDirectNotCloned() {
            return this.callCountDirectNotCloned;
        }

        public int getNodeCount() {
            return this.nodeCountTrivial + this.nodeCountNonTrivial;
        }

        public int getCallCount() {
            return this.getCallCountDirect() + this.callCountIndirect;
        }

        public int getCallCountDirect() {
            return this.callCountDirectDispatched + this.callCountDirectInlined;
        }

        public int getNodeCountTrivial() {
            return this.nodeCountTrivial;
        }

        public int getNodeCountNonTrivial() {
            return this.nodeCountNonTrivial;
        }

        public int getNodeCountMonomorphic() {
            return this.nodeCountMonomorphic;
        }

        public int getNodeCountPolymorphic() {
            return this.nodeCountPolymorphic;
        }

        public int getNodeCountMegamorphic() {
            return this.nodeCountMegamorphic;
        }

        public int getCallCountIndirect() {
            return this.callCountIndirect;
        }

        public int getCallCountDirectDispatched() {
            return this.callCountDirectDispatched;
        }

        public int getCallCountDirectInlined() {
            return this.callCountDirectInlined;
        }

        public int getLoopCount() {
            return this.loopCount;
        }
    }

    private static final class IdentityStatistics<T> {
        final Map<T, TargetIntStatistics> types = new HashMap<T, TargetIntStatistics>();
        private int elementCount;

        private IdentityStatistics() {
        }

        public void printStatistics(PrintWriter out, Function<T, String> toStringFunction, boolean onlyCount, boolean normalize) {
            if (normalize) {
                this.normalize();
            }
            TreeSet<Object> sortedSet = new TreeSet<Object>(Comparator.comparing(c -> -this.types.get(c).getSum()));
            sortedSet.addAll(this.types.keySet());
            sortedSet.forEach(c -> {
                String label = String.format("    %s", toStringFunction.apply(c));
                TargetIntStatistics statistic = this.types.get(c);
                if (onlyCount) {
                    StatisticsListener.printStatistic(out, label, statistic.getCount());
                } else {
                    StatisticsListener.printStatistic(out, label, statistic);
                }
            });
        }

        private void normalize() {
            for (TargetIntStatistics stat : this.types.values()) {
                while (stat.getCount() < (long)this.elementCount) {
                    stat.accept(0, null);
                }
            }
        }

        public void accept(Collection<T> elements, OptimizedCallTarget target) {
            ++this.elementCount;
            HashMap<Object, Integer> histogram = new HashMap<Object, Integer>();
            for (T t : elements) {
                histogram.compute(t, (key, count) -> count == null ? 1 : count + 1);
            }
            for (Map.Entry entry : histogram.entrySet()) {
                Object element = entry.getKey();
                Integer count2 = (Integer)entry.getValue();
                this.types.computeIfAbsent(element, key -> new TargetIntStatistics()).accept(count2, target);
            }
        }
    }

    private static final class TargetLongStatistics
    extends LongSummaryStatistics {
        private String maxName;

        private TargetLongStatistics() {
        }

        public void accept(long value, OptimizedCallTarget target) {
            if (value > this.getMax()) {
                this.maxName = target.getName();
            }
            super.accept(value);
        }

        public String getMaxName() {
            return this.maxName;
        }

        @Override
        @Deprecated
        public void accept(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void combine(LongSummaryStatistics other) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class TargetIntStatistics
    extends IntSummaryStatistics {
        private String maxName;

        private TargetIntStatistics() {
        }

        public void accept(int value, OptimizedCallTarget target) {
            if (value > this.getMax() && target != null) {
                this.maxName = target.getName();
            }
            super.accept(value);
        }

        public String getMaxName() {
            return this.maxName;
        }

        @Override
        @Deprecated
        public void accept(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void combine(IntSummaryStatistics other) {
            throw new UnsupportedOperationException();
        }
    }
}

