/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleNodeSources;

public class TruffleInlining
implements TruffleMetaAccessProvider {
    private final List<CompilableTruffleAST> targetsToDequeue = new ArrayList<CompilableTruffleAST>();
    private final List<CompilableTruffleAST> inlinedTargets = new ArrayList<CompilableTruffleAST>();
    private int callCount = -1;
    private int inlinedCallCount = -1;
    private TruffleNodeSources nodeSources;

    public TruffleNodeSources getTruffleNodeSources() {
        if (this.nodeSources == null) {
            this.nodeSources = new TruffleNodeSources();
        }
        return this.nodeSources;
    }

    public int countCalls() {
        return this.callCount;
    }

    @Override
    public int countInlinedCalls() {
        return this.inlinedCallCount;
    }

    public CompilableTruffleAST[] inlinedTargets() {
        return this.inlinedTargets.toArray(new CompilableTruffleAST[0]);
    }

    @Override
    public void addInlinedTarget(CompilableTruffleAST target) {
        this.inlinedTargets.add(target);
    }

    @Override
    public void setInlinedCallCount(int count) {
        this.inlinedCallCount = count;
    }

    @Override
    public void setCallCount(int count) {
        this.callCount = count;
    }

    @Override
    public OptimizedDirectCallNode findCallNode(JavaConstant callNodeConstant) {
        return OptimizedCallTarget.runtime().asObject(OptimizedDirectCallNode.class, callNodeConstant);
    }

    @Override
    public void addTargetToDequeue(CompilableTruffleAST target) {
        this.targetsToDequeue.add(target);
    }

    public void dequeueTargets() {
        for (CompilableTruffleAST target : this.targetsToDequeue) {
            target.dequeueInlined();
        }
    }

    @Override
    public TruffleSourceLanguagePosition getPosition(JavaConstant node) {
        Node truffleNode = OptimizedCallTarget.runtime().asObject(Node.class, node);
        if (truffleNode == null) {
            return null;
        }
        return this.getTruffleNodeSources().getSourceLocation(truffleNode);
    }

    static class TruffleSourceLanguagePosition
    implements org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition {
        private final SourceSection sourceSection;
        private final Class<?> nodeClass;
        private final int nodeId;

        TruffleSourceLanguagePosition(SourceSection section, Class<?> nodeClass, int nodeId) {
            this.sourceSection = section;
            this.nodeClass = nodeClass;
            this.nodeId = nodeId;
        }

        @Override
        public String getDescription() {
            if (this.sourceSection == null) {
                return "<no-description>";
            }
            return this.sourceSection.getSource().getURI() + " " + this.sourceSection.getStartLine() + ":" + this.sourceSection.getStartColumn();
        }

        @Override
        public int getOffsetEnd() {
            if (this.sourceSection == null) {
                return -1;
            }
            return this.sourceSection.getCharEndIndex();
        }

        @Override
        public int getOffsetStart() {
            if (this.sourceSection == null) {
                return -1;
            }
            return this.sourceSection.getCharIndex();
        }

        @Override
        public int getLineNumber() {
            if (this.sourceSection == null) {
                return -1;
            }
            return this.sourceSection.getStartLine();
        }

        @Override
        public URI getURI() {
            if (this.sourceSection == null) {
                return null;
            }
            return this.sourceSection.getSource().getURI();
        }

        @Override
        public String getLanguage() {
            if (this.sourceSection == null) {
                return null;
            }
            return this.sourceSection.getSource().getLanguage();
        }

        @Override
        public int getNodeId() {
            return this.nodeId;
        }

        @Override
        public String getNodeClassName() {
            return this.nodeClass.getName();
        }
    }
}

