/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.graalvm.compiler.truffle.runtime.CompilationTask;

public final class TraversingBlockingQueue
implements BlockingQueue<Runnable> {
    final BlockingQueue<Runnable> entries = new LinkedBlockingDeque<Runnable>();

    private static CompilationTask task(Runnable entry) {
        return ((CompilationTask.ExecutorServiceWrapper)entry).getCompileTask();
    }

    @Override
    public boolean add(Runnable e) {
        return this.entries.add(e);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        Runnable max = this.takeMax();
        if (max != null) {
            return max;
        }
        return this.entries.poll(timeout, unit);
    }

    @Override
    public Runnable poll() {
        Runnable max = this.takeMax();
        if (max != null) {
            return max;
        }
        return (Runnable)this.entries.poll();
    }

    private synchronized Runnable takeMax() {
        if (this.entries.isEmpty()) {
            return null;
        }
        long time = System.nanoTime();
        Iterator it = this.entries.iterator();
        Runnable max = null;
        while (it.hasNext()) {
            CompilationTask task;
            Runnable entry = (Runnable)it.next();
            if (!(entry instanceof CompilationTask.ExecutorServiceWrapper)) {
                this.removeAndReturn(entry);
            }
            if ((task = TraversingBlockingQueue.task(entry)).isCancelled() || task.updateWeight(time) < 0.0) {
                it.remove();
                continue;
            }
            if (max != null && !task.isHigherPriorityThan(TraversingBlockingQueue.task(max))) continue;
            max = entry;
        }
        return this.removeAndReturn(max);
    }

    private Runnable removeAndReturn(Runnable max) {
        if (this.entries.remove(max)) {
            return max;
        }
        return null;
    }

    @Override
    public boolean offer(Runnable e) {
        return this.entries.offer(e);
    }

    @Override
    public Runnable remove() {
        return (Runnable)this.entries.remove();
    }

    @Override
    public Runnable element() {
        return (Runnable)this.entries.element();
    }

    @Override
    public Runnable peek() {
        return (Runnable)this.entries.peek();
    }

    @Override
    public void put(Runnable e) throws InterruptedException {
        this.entries.put(e);
    }

    @Override
    public boolean offer(Runnable e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.entries.offer(e, timeout, unit);
    }

    @Override
    public Runnable take() throws InterruptedException {
        return this.entries.take();
    }

    @Override
    public int remainingCapacity() {
        return this.entries.remainingCapacity();
    }

    @Override
    public boolean remove(Object o) {
        return this.entries.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.entries.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Runnable> c) {
        return this.entries.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.entries.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.entries.retainAll(c);
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.entries.contains(o);
    }

    @Override
    public Iterator<Runnable> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entries.toArray(a);
    }

    @Override
    public int drainTo(Collection<? super Runnable> c) {
        return this.entries.drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        return this.entries.drainTo(c, maxElements);
    }
}

