/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import org.graalvm.compiler.truffle.runtime.GraalCompilerDirectives;
import org.graalvm.compiler.truffle.runtime.OptimizedOSRLoopNode;

public final class OptimizedLoopNode
extends LoopNode {
    @Node.Child
    private RepeatingNode repeatingNode;

    OptimizedLoopNode(RepeatingNode repeatingNode) {
        this.repeatingNode = repeatingNode;
    }

    public RepeatingNode getRepeatingNode() {
        return this.repeatingNode;
    }

    public void executeLoop(VirtualFrame frame) {
        this.execute(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(VirtualFrame frame) {
        long loopCount = 0L;
        try {
            Object status;
            while (this.repeatingNode.shouldContinue(status = this.repeatingNode.executeRepeatingWithValue(frame))) {
                if (CompilerDirectives.inInterpreter() || GraalCompilerDirectives.inFirstTier()) {
                    ++loopCount;
                }
                TruffleSafepoint.poll((Node)this);
            }
            Object object = status;
            return object;
        }
        finally {
            OptimizedLoopNode.reportLoopCount((Node)this, (int)OptimizedOSRLoopNode.toIntOrMaxInt(loopCount));
        }
    }

    static LoopNode create(RepeatingNode repeatingNode) {
        return new OptimizedLoopNode(repeatingNode);
    }
}

