/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.options;

import com.oracle.truffle.api.dsl.GeneratedBy;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionStability;

@GeneratedBy(value=PolyglotCompilerOptions.class)
final class PolyglotCompilerOptionsOptionDescriptors
implements OptionDescriptors {
    PolyglotCompilerOptionsOptionDescriptors() {
    }

    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "engine.ArgumentTypeSpeculation": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.ArgumentTypeSpeculation, (String)"engine.ArgumentTypeSpeculation").deprecated(false).help("Speculate on arguments types at call sites").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.BackgroundCompilation": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.BackgroundCompilation, (String)"engine.BackgroundCompilation").deprecated(false).help("Enable asynchronous truffle compilation in background threads").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.Compilation": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.Compilation, (String)"engine.Compilation").deprecated(false).help("Enable or disable Truffle compilation.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompilationExceptionsAreFatal": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsAreFatal, (String)"engine.CompilationExceptionsAreFatal").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=ExitVM'").help("Treat compilation exceptions as fatal exceptions that will exit the application").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompilationExceptionsArePrinted": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsArePrinted, (String)"engine.CompilationExceptionsArePrinted").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=Print'").help("Prints the exception stack trace for compilation exceptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompilationExceptionsAreThrown": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsAreThrown, (String)"engine.CompilationExceptionsAreThrown").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=Throw'").help("Treat compilation exceptions as thrown runtime exceptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompilationFailureAction": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationFailureAction, (String)"engine.CompilationFailureAction").deprecated(false).help("Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompilationStatisticDetails": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationStatisticDetails, (String)"engine.CompilationStatisticDetails").deprecated(false).help("Print additional more verbose Truffle compilation statistics at the end of a run.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompilationStatistics": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationStatistics, (String)"engine.CompilationStatistics").deprecated(false).help("Print Truffle compilation statistics at the end of a run.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompilationThreshold": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationThreshold, (String)"engine.CompilationThreshold").deprecated(true).deprecationMessage("").help("Deprecated: use FirstTierCompilationThreshold and LastTierCompilationThreshold, or SingleTierCompilationThreshold if multi-tier compilation is disabled.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompileAOTOnCreate": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileAOTOnCreate, (String)"engine.CompileAOTOnCreate").deprecated(false).help("Compiles created call targets immediately with last tier. Disables background compilation if enabled.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompileImmediately": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileImmediately, (String)"engine.CompileImmediately").deprecated(false).help("Compile immediately to test Truffle compilation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompileOnly": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileOnly, (String)"engine.CompileOnly").deprecated(false).help("Restrict compilation to ','-separated list of includes (or excludes prefixed with '~').").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompilerIdleDelay": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilerIdleDelay, (String)"engine.CompilerIdleDelay").deprecated(false).help("Set the time in milliseconds an idle Truffle compiler thread will wait for new tasks before terminating. New compiler threads will be started once new compilation tasks are submitted. Select '0' to never terminate the Truffle compiler thread. The option is not supported by all Truffle runtimes. On the runtime which doesn't support it the option has no effect.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.CompilerThreads": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilerThreads, (String)"engine.CompilerThreads").deprecated(false).help("Manually set the number of compiler threads").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.EncodedGraphCacheCapacity": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.EncodedGraphCacheCapacity, (String)"engine.EncodedGraphCacheCapacity").deprecated(false).help("Maximum number of entries in the encoded graph cache (< 0 unbounded, 0 disabled).").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.EncodedGraphCachePurgeDelay": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.EncodedGraphCachePurgeDelay, (String)"engine.EncodedGraphCachePurgeDelay").deprecated(false).help("Delay, in milliseconds, after which the encoded graph cache is dropped when the compile queue becomes idle.The option is only supported on the HotSpot (non-libgraal) Truffle runtime.On runtimes which doesn't support it the option has no effect.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.ExcludeAssertions": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.ExcludeAssertions, (String)"engine.ExcludeAssertions").deprecated(false).help("Exclude assertion code from Truffle compilations").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.FirstTierBackedgeCounts": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierBackedgeCounts, (String)"engine.FirstTierBackedgeCounts").deprecated(false).help("Whether to emit look-back-edge counters in the first-tier compilations.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.FirstTierCompilationThreshold": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierCompilationThreshold, (String)"engine.FirstTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root in first tier.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.FirstTierInliningPolicy": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierInliningPolicy, (String)"engine.FirstTierInliningPolicy").deprecated(false).help("Explicitly pick a first tier inlining policy by name (None, TrivialOnly). If empty (default) the lowest priority policy (TrivialOnly) is chosen.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.FirstTierMinInvokeThreshold": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierMinInvokeThreshold, (String)"engine.FirstTierMinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled in the first tier.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.FirstTierUseEconomy": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierUseEconomy, (String)"engine.FirstTierUseEconomy").deprecated(false).help("Whether to use the economy configuration in the first-tier compilations.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.ForceFrameLivenessAnalysis": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.ForceFrameLivenessAnalysis, (String)"engine.ForceFrameLivenessAnalysis").deprecated(false).help("Forces the frame clearing mechanism to be executed, even if Frame.clear() is not used.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InlineAcrossTruffleBoundary": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InlineAcrossTruffleBoundary, (String)"engine.InlineAcrossTruffleBoundary").deprecated(false).help("Enable inlining across Truffle boundary").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.Inlining": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.Inlining, (String)"engine.Inlining").deprecated(false).help("Enable automatic inlining of guest language call targets.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InliningExpansionBudget": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningExpansionBudget, (String)"engine.InliningExpansionBudget").deprecated(false).help("The base expansion budget for language-agnostic inlining.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InliningInliningBudget": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningInliningBudget, (String)"engine.InliningInliningBudget").deprecated(false).help("The base inlining budget for language-agnostic inlining").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InliningPolicy": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningPolicy, (String)"engine.InliningPolicy").deprecated(false).help("Explicitly pick a inlining policy by name. If empty (default) the highest priority chosen by default.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InliningRecursionDepth": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningRecursionDepth, (String)"engine.InliningRecursionDepth").deprecated(false).help("Maximum depth for recursive inlining.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InliningTruffleTierOnExpand": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningTruffleTierOnExpand, (String)"engine.InliningTruffleTierOnExpand").deprecated(false).help("Perform a set of optimizations on each explored call target during inlining.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InstrumentBoundaries": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBoundaries, (String)"engine.InstrumentBoundaries").deprecated(false).help("Instrument Truffle boundaries and output profiling information to the standard output.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InstrumentBoundariesPerInlineSite": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBoundariesPerInlineSite, (String)"engine.InstrumentBoundariesPerInlineSite").deprecated(false).help("Instrument Truffle boundaries by considering different inlining sites as different branches.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InstrumentBranches": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBranches, (String)"engine.InstrumentBranches").deprecated(false).help("Instrument branches and output profiling information to the standard output.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InstrumentBranchesPerInlineSite": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBranchesPerInlineSite, (String)"engine.InstrumentBranchesPerInlineSite").deprecated(false).help("Instrument branches by considering different inlining sites as different branches.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InstrumentFilter": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentFilter, (String)"engine.InstrumentFilter").deprecated(false).help("Method filter for host methods in which to add instrumentation.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InstrumentationTableSize": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentationTableSize, (String)"engine.InstrumentationTableSize").deprecated(false).help("Maximum number of instrumentation counters available.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.InvalidationReprofileCount": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InvalidationReprofileCount, (String)"engine.InvalidationReprofileCount").deprecated(true).deprecationMessage("").help("Delay compilation after an invalidation to allow for reprofiling. Deprecated: no longer has any effect.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.IterativePartialEscape": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.IterativePartialEscape, (String)"engine.IterativePartialEscape").deprecated(false).help("Run the partial escape analysis iteratively in Truffle compilation.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.LastTierCompilationThreshold": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.LastTierCompilationThreshold, (String)"engine.LastTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root in last tier.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.MaximumGraalNodeCount": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MaximumGraalNodeCount, (String)"engine.MaximumGraalNodeCount").deprecated(false).help("Stop partial evaluation when the graph exceeded this many nodes.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.MaximumInlineNodeCount": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MaximumInlineNodeCount, (String)"engine.MaximumInlineNodeCount").deprecated(false).help("Ignore further truffle inlining decisions when the graph exceeded this many nodes.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.MethodExpansionStatistics": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MethodExpansionStatistics, (String)"engine.MethodExpansionStatistics").deprecated(false).help("Print statistics on expanded Java methods during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.MinInvokeThreshold": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MinInvokeThreshold, (String)"engine.MinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.Mode": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.Mode, (String)"engine.Mode").deprecated(false).help("Configures the execution mode of the engine. Available modes are 'latency' and 'throughput'. The default value balances between the two.").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "engine.MultiTier": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MultiTier, (String)"engine.MultiTier").deprecated(false).help("Whether to use multiple Truffle compilation tiers by default.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.NodeExpansionStatistics": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.NodeExpansionStatistics, (String)"engine.NodeExpansionStatistics").deprecated(false).help("Print statistics on expanded Truffle nodes during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.NodeSourcePositions": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.NodeSourcePositions, (String)"engine.NodeSourcePositions").deprecated(false).help("Enable node source positions in truffle partial evaluations.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.OSR": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.OSR, (String)"engine.OSR").deprecated(false).help("Enable automatic on-stack-replacement of loops.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.OSRCompilationThreshold": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.OSRCompilationThreshold, (String)"engine.OSRCompilationThreshold").deprecated(false).help("Number of loop iterations until on-stack-replacement compilation is triggered.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.PartialBlockCompilation": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockCompilation, (String)"engine.PartialBlockCompilation").deprecated(false).help("Enable partial compilation for BlockNode.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.PartialBlockCompilationSize": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockCompilationSize, (String)"engine.PartialBlockCompilationSize").deprecated(false).help("Sets the target non-trivial Truffle node size for partial compilation of BlockNode nodes.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.PartialBlockMaximumSize": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockMaximumSize, (String)"engine.PartialBlockMaximumSize").deprecated(false).help("Sets the maximum non-trivial Truffle node size for partial compilation of BlockNode nodes.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.PerformanceWarningsAreFatal": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PerformanceWarningsAreFatal, (String)"engine.PerformanceWarningsAreFatal").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=ExitVM' 'engine.TreatPerformanceWarningsAsErrors=<PerformanceWarningKinds>'").help("Treat performance warnings as fatal occurrences that will exit the applications").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.PrintExpansionHistogram": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PrintExpansionHistogram, (String)"engine.PrintExpansionHistogram").deprecated(true).deprecationMessage("The expansion histogram was superseeded by engine.TraceMethodExpansion, engine.TraceNodeExpansion, engine.MethodExpansionHistogram and engine.NodeExpansionHistogram.").help("Prints a histogram of all expanded Java methods.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.PriorityQueue": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PriorityQueue, (String)"engine.PriorityQueue").deprecated(false).help("Use the priority of compilation jobs in the compilation queue.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.Profiling": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.Profiling, (String)"engine.Profiling").deprecated(false).help("Enable/disable builtin profiles in com.oracle.truffle.api.profiles.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.ReplaceReprofileCount": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.ReplaceReprofileCount, (String)"engine.ReplaceReprofileCount").deprecated(true).deprecationMessage("").help("Delay compilation after a node replacement. Deprecated: no longer has any effect.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.ReturnTypeSpeculation": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.ReturnTypeSpeculation, (String)"engine.ReturnTypeSpeculation").deprecated(false).help("Speculate on return types at call sites").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SingleTierCompilationThreshold": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SingleTierCompilationThreshold, (String)"engine.SingleTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root when not using multi tier.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.Splitting": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.Splitting, (String)"engine.Splitting").deprecated(false).help("Enable automatic duplication of compilation profiles (splitting).").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SplittingAllowForcedSplits": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingAllowForcedSplits, (String)"engine.SplittingAllowForcedSplits").deprecated(false).help("Should forced splits be allowed.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SplittingDumpDecisions": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingDumpDecisions, (String)"engine.SplittingDumpDecisions").deprecated(false).help("Dumps to IGV information on polymorphic events").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SplittingGrowthLimit": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingGrowthLimit, (String)"engine.SplittingGrowthLimit").deprecated(false).help("Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SplittingMaxCalleeSize": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingMaxCalleeSize, (String)"engine.SplittingMaxCalleeSize").deprecated(false).help("Disable call target splitting if tree size exceeds this limit").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SplittingMaxPropagationDepth": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingMaxPropagationDepth, (String)"engine.SplittingMaxPropagationDepth").deprecated(false).help("Propagate info about a polymorphic specialize through maximum this many call targets").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.SplittingTraceEvents": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingTraceEvents, (String)"engine.SplittingTraceEvents").deprecated(false).help("Trace details of splitting events and decisions.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceAssumptions": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceAssumptions, (String)"engine.TraceAssumptions").deprecated(false).help("Print stack trace on assumption invalidation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceCompilation": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilation, (String)"engine.TraceCompilation").deprecated(false).help("Print information for compilation results.").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "engine.TraceCompilationAST": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationAST, (String)"engine.TraceCompilationAST").deprecated(false).help("Print the entire AST after each compilation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceCompilationDetails": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationDetails, (String)"engine.TraceCompilationDetails").deprecated(false).help("Print information for compilation queuing.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceCompilationPolymorphism": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationPolymorphism, (String)"engine.TraceCompilationPolymorphism").deprecated(false).help("Print all polymorphic and generic nodes after each compilation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceInlining": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceInlining, (String)"engine.TraceInlining").deprecated(false).help("Print information for inlining decisions.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceInliningDetails": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceInliningDetails, (String)"engine.TraceInliningDetails").deprecated(false).help("Print detailed information for inlining (i.e. the entire explored call tree).").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceMethodExpansion": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceMethodExpansion, (String)"engine.TraceMethodExpansion").deprecated(false).help("Print a tree of all expanded Java methods with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceNodeExpansion": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceNodeExpansion, (String)"engine.TraceNodeExpansion").deprecated(false).help("Print a tree of all expanded Truffle nodes with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TracePerformanceWarnings": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TracePerformanceWarnings, (String)"engine.TracePerformanceWarnings").deprecated(false).help("Print potential performance problems").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceSplitting": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceSplitting, (String)"engine.TraceSplitting").deprecated(false).help("Print information for splitting decisions.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceSplittingSummary": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceSplittingSummary, (String)"engine.TraceSplittingSummary").deprecated(false).help("Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceStackTraceLimit": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceStackTraceLimit, (String)"engine.TraceStackTraceLimit").deprecated(false).help("Number of stack trace elements printed by TraceTruffleTransferToInterpreter and TraceTruffleAssumptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraceTransferToInterpreter": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceTransferToInterpreter, (String)"engine.TraceTransferToInterpreter").deprecated(false).help("Print stack trace on transfer to interpreter.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraversingCompilationQueue": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingCompilationQueue, (String)"engine.TraversingCompilationQueue").deprecated(false).help("Use a traversing compilation queue.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraversingQueueFirstTierPriority": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingQueueFirstTierPriority, (String)"engine.TraversingQueueFirstTierPriority").deprecated(false).help("Traversing queue gives first tier compilations priority.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TraversingQueueWeightingBothTiers": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingQueueWeightingBothTiers, (String)"engine.TraversingQueueWeightingBothTiers").deprecated(false).help("Traversing queue uses rate as priority for both tier.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.TreatPerformanceWarningsAsErrors": {
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TreatPerformanceWarningsAsErrors, (String)"engine.TreatPerformanceWarningsAsErrors").deprecated(false).help("Treat performance warnings as error. Handling of the error depends on the CompilationFailureAction option value").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(OptionDescriptor.newBuilder(PolyglotCompilerOptions.ArgumentTypeSpeculation, (String)"engine.ArgumentTypeSpeculation").deprecated(false).help("Speculate on arguments types at call sites").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.BackgroundCompilation, (String)"engine.BackgroundCompilation").deprecated(false).help("Enable asynchronous truffle compilation in background threads").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.Compilation, (String)"engine.Compilation").deprecated(false).help("Enable or disable Truffle compilation.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsAreFatal, (String)"engine.CompilationExceptionsAreFatal").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=ExitVM'").help("Treat compilation exceptions as fatal exceptions that will exit the application").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsArePrinted, (String)"engine.CompilationExceptionsArePrinted").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=Print'").help("Prints the exception stack trace for compilation exceptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsAreThrown, (String)"engine.CompilationExceptionsAreThrown").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=Throw'").help("Treat compilation exceptions as thrown runtime exceptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationFailureAction, (String)"engine.CompilationFailureAction").deprecated(false).help("Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationStatisticDetails, (String)"engine.CompilationStatisticDetails").deprecated(false).help("Print additional more verbose Truffle compilation statistics at the end of a run.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationStatistics, (String)"engine.CompilationStatistics").deprecated(false).help("Print Truffle compilation statistics at the end of a run.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationThreshold, (String)"engine.CompilationThreshold").deprecated(true).deprecationMessage("").help("Deprecated: use FirstTierCompilationThreshold and LastTierCompilationThreshold, or SingleTierCompilationThreshold if multi-tier compilation is disabled.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileAOTOnCreate, (String)"engine.CompileAOTOnCreate").deprecated(false).help("Compiles created call targets immediately with last tier. Disables background compilation if enabled.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileImmediately, (String)"engine.CompileImmediately").deprecated(false).help("Compile immediately to test Truffle compilation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileOnly, (String)"engine.CompileOnly").deprecated(false).help("Restrict compilation to ','-separated list of includes (or excludes prefixed with '~').").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilerIdleDelay, (String)"engine.CompilerIdleDelay").deprecated(false).help("Set the time in milliseconds an idle Truffle compiler thread will wait for new tasks before terminating. New compiler threads will be started once new compilation tasks are submitted. Select '0' to never terminate the Truffle compiler thread. The option is not supported by all Truffle runtimes. On the runtime which doesn't support it the option has no effect.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilerThreads, (String)"engine.CompilerThreads").deprecated(false).help("Manually set the number of compiler threads").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.EncodedGraphCacheCapacity, (String)"engine.EncodedGraphCacheCapacity").deprecated(false).help("Maximum number of entries in the encoded graph cache (< 0 unbounded, 0 disabled).").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.EncodedGraphCachePurgeDelay, (String)"engine.EncodedGraphCachePurgeDelay").deprecated(false).help("Delay, in milliseconds, after which the encoded graph cache is dropped when the compile queue becomes idle.The option is only supported on the HotSpot (non-libgraal) Truffle runtime.On runtimes which doesn't support it the option has no effect.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.ExcludeAssertions, (String)"engine.ExcludeAssertions").deprecated(false).help("Exclude assertion code from Truffle compilations").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierBackedgeCounts, (String)"engine.FirstTierBackedgeCounts").deprecated(false).help("Whether to emit look-back-edge counters in the first-tier compilations.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierCompilationThreshold, (String)"engine.FirstTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root in first tier.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierInliningPolicy, (String)"engine.FirstTierInliningPolicy").deprecated(false).help("Explicitly pick a first tier inlining policy by name (None, TrivialOnly). If empty (default) the lowest priority policy (TrivialOnly) is chosen.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierMinInvokeThreshold, (String)"engine.FirstTierMinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled in the first tier.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierUseEconomy, (String)"engine.FirstTierUseEconomy").deprecated(false).help("Whether to use the economy configuration in the first-tier compilations.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.ForceFrameLivenessAnalysis, (String)"engine.ForceFrameLivenessAnalysis").deprecated(false).help("Forces the frame clearing mechanism to be executed, even if Frame.clear() is not used.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InlineAcrossTruffleBoundary, (String)"engine.InlineAcrossTruffleBoundary").deprecated(false).help("Enable inlining across Truffle boundary").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.Inlining, (String)"engine.Inlining").deprecated(false).help("Enable automatic inlining of guest language call targets.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningExpansionBudget, (String)"engine.InliningExpansionBudget").deprecated(false).help("The base expansion budget for language-agnostic inlining.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningInliningBudget, (String)"engine.InliningInliningBudget").deprecated(false).help("The base inlining budget for language-agnostic inlining").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningPolicy, (String)"engine.InliningPolicy").deprecated(false).help("Explicitly pick a inlining policy by name. If empty (default) the highest priority chosen by default.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningRecursionDepth, (String)"engine.InliningRecursionDepth").deprecated(false).help("Maximum depth for recursive inlining.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningTruffleTierOnExpand, (String)"engine.InliningTruffleTierOnExpand").deprecated(false).help("Perform a set of optimizations on each explored call target during inlining.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBoundaries, (String)"engine.InstrumentBoundaries").deprecated(false).help("Instrument Truffle boundaries and output profiling information to the standard output.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBoundariesPerInlineSite, (String)"engine.InstrumentBoundariesPerInlineSite").deprecated(false).help("Instrument Truffle boundaries by considering different inlining sites as different branches.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBranches, (String)"engine.InstrumentBranches").deprecated(false).help("Instrument branches and output profiling information to the standard output.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBranchesPerInlineSite, (String)"engine.InstrumentBranchesPerInlineSite").deprecated(false).help("Instrument branches by considering different inlining sites as different branches.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentFilter, (String)"engine.InstrumentFilter").deprecated(false).help("Method filter for host methods in which to add instrumentation.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentationTableSize, (String)"engine.InstrumentationTableSize").deprecated(false).help("Maximum number of instrumentation counters available.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.InvalidationReprofileCount, (String)"engine.InvalidationReprofileCount").deprecated(true).deprecationMessage("").help("Delay compilation after an invalidation to allow for reprofiling. Deprecated: no longer has any effect.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.IterativePartialEscape, (String)"engine.IterativePartialEscape").deprecated(false).help("Run the partial escape analysis iteratively in Truffle compilation.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.LastTierCompilationThreshold, (String)"engine.LastTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root in last tier.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.MaximumGraalNodeCount, (String)"engine.MaximumGraalNodeCount").deprecated(false).help("Stop partial evaluation when the graph exceeded this many nodes.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.MaximumInlineNodeCount, (String)"engine.MaximumInlineNodeCount").deprecated(false).help("Ignore further truffle inlining decisions when the graph exceeded this many nodes.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.MethodExpansionStatistics, (String)"engine.MethodExpansionStatistics").deprecated(false).help("Print statistics on expanded Java methods during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.MinInvokeThreshold, (String)"engine.MinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.Mode, (String)"engine.Mode").deprecated(false).help("Configures the execution mode of the engine. Available modes are 'latency' and 'throughput'. The default value balances between the two.").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.MultiTier, (String)"engine.MultiTier").deprecated(false).help("Whether to use multiple Truffle compilation tiers by default.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.NodeExpansionStatistics, (String)"engine.NodeExpansionStatistics").deprecated(false).help("Print statistics on expanded Truffle nodes during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.NodeSourcePositions, (String)"engine.NodeSourcePositions").deprecated(false).help("Enable node source positions in truffle partial evaluations.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.OSR, (String)"engine.OSR").deprecated(false).help("Enable automatic on-stack-replacement of loops.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.OSRCompilationThreshold, (String)"engine.OSRCompilationThreshold").deprecated(false).help("Number of loop iterations until on-stack-replacement compilation is triggered.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockCompilation, (String)"engine.PartialBlockCompilation").deprecated(false).help("Enable partial compilation for BlockNode.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockCompilationSize, (String)"engine.PartialBlockCompilationSize").deprecated(false).help("Sets the target non-trivial Truffle node size for partial compilation of BlockNode nodes.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockMaximumSize, (String)"engine.PartialBlockMaximumSize").deprecated(false).help("Sets the maximum non-trivial Truffle node size for partial compilation of BlockNode nodes.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.PerformanceWarningsAreFatal, (String)"engine.PerformanceWarningsAreFatal").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=ExitVM' 'engine.TreatPerformanceWarningsAsErrors=<PerformanceWarningKinds>'").help("Treat performance warnings as fatal occurrences that will exit the applications").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.PrintExpansionHistogram, (String)"engine.PrintExpansionHistogram").deprecated(true).deprecationMessage("The expansion histogram was superseeded by engine.TraceMethodExpansion, engine.TraceNodeExpansion, engine.MethodExpansionHistogram and engine.NodeExpansionHistogram.").help("Prints a histogram of all expanded Java methods.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.PriorityQueue, (String)"engine.PriorityQueue").deprecated(false).help("Use the priority of compilation jobs in the compilation queue.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.Profiling, (String)"engine.Profiling").deprecated(false).help("Enable/disable builtin profiles in com.oracle.truffle.api.profiles.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.ReplaceReprofileCount, (String)"engine.ReplaceReprofileCount").deprecated(true).deprecationMessage("").help("Delay compilation after a node replacement. Deprecated: no longer has any effect.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.ReturnTypeSpeculation, (String)"engine.ReturnTypeSpeculation").deprecated(false).help("Speculate on return types at call sites").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.SingleTierCompilationThreshold, (String)"engine.SingleTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root when not using multi tier.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.Splitting, (String)"engine.Splitting").deprecated(false).help("Enable automatic duplication of compilation profiles (splitting).").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingAllowForcedSplits, (String)"engine.SplittingAllowForcedSplits").deprecated(false).help("Should forced splits be allowed.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingDumpDecisions, (String)"engine.SplittingDumpDecisions").deprecated(false).help("Dumps to IGV information on polymorphic events").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingGrowthLimit, (String)"engine.SplittingGrowthLimit").deprecated(false).help("Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingMaxCalleeSize, (String)"engine.SplittingMaxCalleeSize").deprecated(false).help("Disable call target splitting if tree size exceeds this limit").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingMaxPropagationDepth, (String)"engine.SplittingMaxPropagationDepth").deprecated(false).help("Propagate info about a polymorphic specialize through maximum this many call targets").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingTraceEvents, (String)"engine.SplittingTraceEvents").deprecated(false).help("Trace details of splitting events and decisions.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceAssumptions, (String)"engine.TraceAssumptions").deprecated(false).help("Print stack trace on assumption invalidation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilation, (String)"engine.TraceCompilation").deprecated(false).help("Print information for compilation results.").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationAST, (String)"engine.TraceCompilationAST").deprecated(false).help("Print the entire AST after each compilation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationDetails, (String)"engine.TraceCompilationDetails").deprecated(false).help("Print information for compilation queuing.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationPolymorphism, (String)"engine.TraceCompilationPolymorphism").deprecated(false).help("Print all polymorphic and generic nodes after each compilation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceInlining, (String)"engine.TraceInlining").deprecated(false).help("Print information for inlining decisions.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceInliningDetails, (String)"engine.TraceInliningDetails").deprecated(false).help("Print detailed information for inlining (i.e. the entire explored call tree).").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceMethodExpansion, (String)"engine.TraceMethodExpansion").deprecated(false).help("Print a tree of all expanded Java methods with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceNodeExpansion, (String)"engine.TraceNodeExpansion").deprecated(false).help("Print a tree of all expanded Truffle nodes with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TracePerformanceWarnings, (String)"engine.TracePerformanceWarnings").deprecated(false).help("Print potential performance problems").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceSplitting, (String)"engine.TraceSplitting").deprecated(false).help("Print information for splitting decisions.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceSplittingSummary, (String)"engine.TraceSplittingSummary").deprecated(false).help("Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceStackTraceLimit, (String)"engine.TraceStackTraceLimit").deprecated(false).help("Number of stack trace elements printed by TraceTruffleTransferToInterpreter and TraceTruffleAssumptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceTransferToInterpreter, (String)"engine.TraceTransferToInterpreter").deprecated(false).help("Print stack trace on transfer to interpreter.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingCompilationQueue, (String)"engine.TraversingCompilationQueue").deprecated(false).help("Use a traversing compilation queue.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingQueueFirstTierPriority, (String)"engine.TraversingQueueFirstTierPriority").deprecated(false).help("Traversing queue gives first tier compilations priority.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingQueueWeightingBothTiers, (String)"engine.TraversingQueueWeightingBothTiers").deprecated(false).help("Traversing queue uses rate as priority for both tier.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(PolyglotCompilerOptions.TreatPerformanceWarningsAsErrors, (String)"engine.TreatPerformanceWarningsAsErrors").deprecated(false).help("Treat performance warnings as error. Handling of the error depends on the CompilationFailureAction option value").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build()).iterator();
    }
}

