/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.options;

import com.oracle.truffle.api.Option;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptionsOptionDescriptors;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;

@Option.Group(value={"engine"})
public final class PolyglotCompilerOptions {
    static final OptionType<EngineModeEnum> ENGINE_MODE_TYPE = new OptionType("EngineMode", (Function)new Function<String, EngineModeEnum>(){

        @Override
        public EngineModeEnum apply(String s) {
            try {
                return EngineModeEnum.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Mode can be: 'default', 'latency' or 'throughput'.");
            }
        }
    });
    static final OptionType<Set<CompilationTier>> COMPILATION_TIERS_TYPE = new OptionType("Tier", (Function)new Function<String, Set<CompilationTier>>(){

        @Override
        public Set<CompilationTier> apply(String s) {
            if (s.equals("true")) {
                return Collections.singleton(CompilationTier.truffleTier);
            }
            if (s.equals("false")) {
                return Collections.emptySet();
            }
            String[] strings = s.split(",");
            EnumSet<CompilationTier> tiers = EnumSet.noneOf(CompilationTier.class);
            for (int i = 0; i < strings.length; ++i) {
                tiers.add(CompilationTier.parse(strings[i]));
            }
            return Collections.unmodifiableSet(tiers);
        }
    });
    static final OptionType<ExceptionAction> EXCEPTION_ACTION_TYPE = new OptionType("ExceptionAction", (Function)new Function<String, ExceptionAction>(){

        @Override
        public ExceptionAction apply(String s) {
            try {
                return ExceptionAction.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.");
            }
        }
    });
    static final OptionType<Set<PerformanceWarningKind>> PERFORMANCE_WARNING_TYPE = new OptionType("PerformanceWarningKind", (Function)new Function<String, Set<PerformanceWarningKind>>(){

        @Override
        public Set<PerformanceWarningKind> apply(String value) {
            if ("none".equals(value)) {
                return EnumSet.noneOf(PerformanceWarningKind.class);
            }
            if ("all".equals(value)) {
                return EnumSet.allOf(PerformanceWarningKind.class);
            }
            EnumSet<PerformanceWarningKind> result = EnumSet.noneOf(PerformanceWarningKind.class);
            for (String name : value.split(",")) {
                if ("bailout".equals(name)) continue;
                try {
                    result.add(PerformanceWarningKind.forName(name));
                }
                catch (IllegalArgumentException e) {
                    String message = String.format("The \"%s\" is not a valid performance warning kind. Valid values are%n", name);
                    for (PerformanceWarningKind kind : PerformanceWarningKind.values()) {
                        message = message + String.format("%s%s%s%n", kind.name, this.indent(kind.name.length()), kind.help);
                    }
                    message = message + String.format("all%sEnables all performance warnings%n", this.indent(3));
                    message = message + String.format("none%sDisables performance warnings%n", this.indent(4));
                    throw new IllegalArgumentException(message);
                }
            }
            return result;
        }

        private String indent(int nameLength) {
            int len = Math.max(1, 16 - nameLength);
            return new String(new char[len]).replace('\u0000', ' ');
        }
    });
    @Option(help="Configures the execution mode of the engine. Available modes are 'latency' and 'throughput'. The default value balances between the two.", category=OptionCategory.EXPERT, stability=OptionStability.STABLE)
    public static final OptionKey<EngineModeEnum> Mode = new OptionKey((Object)EngineModeEnum.DEFAULT, ENGINE_MODE_TYPE);
    @Option(help="Enable or disable Truffle compilation.", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> Compilation = new OptionKey((Object)true);
    @Option(help="Restrict compilation to ','-separated list of includes (or excludes prefixed with '~').", category=OptionCategory.INTERNAL)
    public static final OptionKey<String> CompileOnly = new OptionKey(null, OptionType.defaultType(String.class));
    @Option(help="Compile immediately to test Truffle compilation", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> CompileImmediately = new OptionKey((Object)false);
    @Option(help="Compiles created call targets immediately with last tier. Disables background compilation if enabled.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> CompileAOTOnCreate = new OptionKey((Object)false);
    @Option(help="Enable asynchronous truffle compilation in background threads", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> BackgroundCompilation = new OptionKey((Object)true);
    @Option(help="Manually set the number of compiler threads", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> CompilerThreads = new OptionKey((Object)-1);
    @Option(help="Set the time in milliseconds an idle Truffle compiler thread will wait for new tasks before terminating. New compiler threads will be started once new compilation tasks are submitted. Select '0' to never terminate the Truffle compiler thread. The option is not supported by all Truffle runtimes. On the runtime which doesn't support it the option has no effect.", category=OptionCategory.EXPERT)
    public static final OptionKey<Long> CompilerIdleDelay = new OptionKey((Object)10000L);
    @Option(help="Minimum number of invocations or loop iterations needed to compile a guest language root when not using multi tier.", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> SingleTierCompilationThreshold = new OptionKey((Object)1000);
    @Option(help="Deprecated: use FirstTierCompilationThreshold and LastTierCompilationThreshold, or SingleTierCompilationThreshold if multi-tier compilation is disabled.", category=OptionCategory.EXPERT, deprecated=true)
    public static final OptionKey<Integer> CompilationThreshold = new OptionKey((Object)1000);
    @Option(help="Minimum number of calls before a call target is compiled", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> MinInvokeThreshold = new OptionKey((Object)3);
    @Option(help="Delay compilation after an invalidation to allow for reprofiling. Deprecated: no longer has any effect.", category=OptionCategory.EXPERT, deprecated=true)
    public static final OptionKey<Integer> InvalidationReprofileCount = new OptionKey((Object)3);
    @Option(help="Delay compilation after a node replacement. Deprecated: no longer has any effect.", category=OptionCategory.EXPERT, deprecated=true)
    public static final OptionKey<Integer> ReplaceReprofileCount = new OptionKey((Object)3);
    @Option(help="Speculate on arguments types at call sites", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> ArgumentTypeSpeculation = new OptionKey((Object)true);
    @Option(help="Speculate on return types at call sites", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> ReturnTypeSpeculation = new OptionKey((Object)true);
    @Option(help="Enable/disable builtin profiles in com.oracle.truffle.api.profiles.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> Profiling = new OptionKey((Object)true);
    @Option(help="Whether to use multiple Truffle compilation tiers by default.", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> MultiTier = new OptionKey((Object)true);
    @Option(help="Explicitly pick a first tier inlining policy by name (None, TrivialOnly). If empty (default) the lowest priority policy (TrivialOnly) is chosen.", category=OptionCategory.INTERNAL)
    public static final OptionKey<String> FirstTierInliningPolicy = new OptionKey((Object)"");
    @Option(help="Minimum number of invocations or loop iterations needed to compile a guest language root in first tier.", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> FirstTierCompilationThreshold = new OptionKey((Object)400);
    @Option(help="Minimum number of invocations or loop iterations needed to compile a guest language root in last tier.", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> LastTierCompilationThreshold = new OptionKey((Object)10000);
    @Option(help="Minimum number of calls before a call target is compiled in the first tier.", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> FirstTierMinInvokeThreshold = new OptionKey((Object)1);
    @Option(help="Whether to use the economy configuration in the first-tier compilations.", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> FirstTierUseEconomy = new OptionKey((Object)true);
    @Option(help="Whether to emit look-back-edge counters in the first-tier compilations.", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> FirstTierBackedgeCounts = new OptionKey((Object)true);
    @Option(help="Prints the exception stack trace for compilation exceptions", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="Use 'engine.CompilationFailureAction=Print'")
    public static final OptionKey<Boolean> CompilationExceptionsArePrinted = new OptionKey((Object)false);
    @Option(help="Treat compilation exceptions as thrown runtime exceptions", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="Use 'engine.CompilationFailureAction=Throw'")
    public static final OptionKey<Boolean> CompilationExceptionsAreThrown = new OptionKey((Object)false);
    @Option(help="Treat compilation exceptions as fatal exceptions that will exit the application", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="Use 'engine.CompilationFailureAction=ExitVM'")
    public static final OptionKey<Boolean> CompilationExceptionsAreFatal = new OptionKey((Object)false);
    @Option(help="Treat performance warnings as fatal occurrences that will exit the applications", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="Use 'engine.CompilationFailureAction=ExitVM' 'engine.TreatPerformanceWarningsAsErrors=<PerformanceWarningKinds>'")
    public static final OptionKey<Set<PerformanceWarningKind>> PerformanceWarningsAreFatal = new OptionKey(Collections.emptySet(), PERFORMANCE_WARNING_TYPE);
    @Option(help="Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.", category=OptionCategory.INTERNAL)
    public static final OptionKey<ExceptionAction> CompilationFailureAction = new OptionKey((Object)ExceptionAction.Silent, EXCEPTION_ACTION_TYPE);
    @Option(help="Treat performance warnings as error. Handling of the error depends on the CompilationFailureAction option value", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<PerformanceWarningKind>> TreatPerformanceWarningsAsErrors = new OptionKey(Collections.emptySet(), PERFORMANCE_WARNING_TYPE);
    @Option(help="Print information for compilation results.", category=OptionCategory.EXPERT, stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> TraceCompilation = new OptionKey((Object)false);
    @Option(help="Print information for compilation queuing.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceCompilationDetails = new OptionKey((Object)false);
    @Option(help="Print all polymorphic and generic nodes after each compilation", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceCompilationPolymorphism = new OptionKey((Object)false);
    @Option(help="Print the entire AST after each compilation", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceCompilationAST = new OptionKey((Object)false);
    @Option(help="Print information for inlining decisions.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceInlining = new OptionKey((Object)false);
    @Option(help="Print information for splitting decisions.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceSplitting = new OptionKey((Object)false);
    @Option(help="Print stack trace on assumption invalidation", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceAssumptions = new OptionKey((Object)false);
    @Option(help="Number of stack trace elements printed by TraceTruffleTransferToInterpreter and TraceTruffleAssumptions", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> TraceStackTraceLimit = new OptionKey((Object)20);
    @Option(help="Print Truffle compilation statistics at the end of a run.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> CompilationStatistics = new OptionKey((Object)false);
    @Option(help="Print additional more verbose Truffle compilation statistics at the end of a run.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> CompilationStatisticDetails = new OptionKey((Object)false);
    @Option(help="Print stack trace on transfer to interpreter.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceTransferToInterpreter = new OptionKey((Object)false);
    private static final String EXPANSION_VALUES = "Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n";
    @Option(help="Print a tree of all expanded Java methods with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<CompilationTier>> TraceMethodExpansion = new OptionKey(Collections.emptySet(), COMPILATION_TIERS_TYPE);
    @Option(help="Print a tree of all expanded Truffle nodes with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<CompilationTier>> TraceNodeExpansion = new OptionKey(Collections.emptySet(), COMPILATION_TIERS_TYPE);
    @Option(help="Print statistics on expanded Java methods during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<CompilationTier>> MethodExpansionStatistics = new OptionKey(Collections.emptySet(), COMPILATION_TIERS_TYPE);
    @Option(help="Print statistics on expanded Truffle nodes during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier) :%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.%n", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<CompilationTier>> NodeExpansionStatistics = new OptionKey(Collections.emptySet(), COMPILATION_TIERS_TYPE);
    @Option(help="Prints a histogram of all expanded Java methods.", category=OptionCategory.INTERNAL, deprecated=true, deprecationMessage="The expansion histogram was superseeded by engine.TraceMethodExpansion, engine.TraceNodeExpansion, engine.MethodExpansionHistogram and engine.NodeExpansionHistogram.")
    public static final OptionKey<Boolean> PrintExpansionHistogram = new OptionKey((Object)false);
    @Option(help="Enable automatic inlining of guest language call targets.", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> Inlining = new OptionKey((Object)true);
    @Option(help="Maximum depth for recursive inlining.", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> InliningRecursionDepth = new OptionKey((Object)2);
    @Option(help="Perform a set of optimizations on each explored call target during inlining.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InliningTruffleTierOnExpand = new OptionKey((Object)true);
    @Option(help="Enable automatic duplication of compilation profiles (splitting).", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> Splitting = new OptionKey((Object)true);
    @Option(help="Disable call target splitting if tree size exceeds this limit", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> SplittingMaxCalleeSize = new OptionKey((Object)100);
    @Option(help="Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count", category=OptionCategory.INTERNAL)
    public static final OptionKey<Double> SplittingGrowthLimit = new OptionKey((Object)1.5);
    @Option(help="Propagate info about a polymorphic specialize through maximum this many call targets", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> SplittingMaxPropagationDepth = new OptionKey((Object)5);
    @Option(help="Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceSplittingSummary = new OptionKey((Object)false);
    @Option(help="Trace details of splitting events and decisions.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> SplittingTraceEvents = new OptionKey((Object)false);
    @Option(help="Dumps to IGV information on polymorphic events", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> SplittingDumpDecisions = new OptionKey((Object)false);
    @Option(help="Should forced splits be allowed.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> SplittingAllowForcedSplits = new OptionKey((Object)true);
    @Option(help="Enable automatic on-stack-replacement of loops.", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> OSR = new OptionKey((Object)true);
    @Option(help="Number of loop iterations until on-stack-replacement compilation is triggered.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> OSRCompilationThreshold = new OptionKey((Object)100000);
    @Option(help="Enable partial compilation for BlockNode.", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> PartialBlockCompilation = new OptionKey((Object)true);
    @Option(help="Sets the target non-trivial Truffle node size for partial compilation of BlockNode nodes.", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> PartialBlockCompilationSize = new OptionKey((Object)3000);
    @Option(help="Sets the maximum non-trivial Truffle node size for partial compilation of BlockNode nodes.", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> PartialBlockMaximumSize = new OptionKey((Object)10000);
    @Option(help="Enable inlining across Truffle boundary", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InlineAcrossTruffleBoundary = new OptionKey((Object)false);
    @Option(help="Print potential performance problems", category=OptionCategory.INTERNAL)
    public static final OptionKey<Set<PerformanceWarningKind>> TracePerformanceWarnings = new OptionKey(Collections.emptySet(), PERFORMANCE_WARNING_TYPE);
    @Option(help="Run the partial escape analysis iteratively in Truffle compilation.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> IterativePartialEscape = new OptionKey((Object)false);
    @Option(help="Method filter for host methods in which to add instrumentation.", category=OptionCategory.INTERNAL)
    public static final OptionKey<String> InstrumentFilter = new OptionKey((Object)"*.*.*");
    @Option(help="Maximum number of instrumentation counters available.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> InstrumentationTableSize = new OptionKey((Object)10000);
    @Option(help="Stop partial evaluation when the graph exceeded this many nodes.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> MaximumGraalNodeCount = new OptionKey((Object)400000);
    @Option(help="Ignore further truffle inlining decisions when the graph exceeded this many nodes.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Integer> MaximumInlineNodeCount = new OptionKey((Object)150000);
    @Option(help="Exclude assertion code from Truffle compilations", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> ExcludeAssertions = new OptionKey((Object)true);
    @Option(help="Enable node source positions in truffle partial evaluations.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> NodeSourcePositions = new OptionKey((Object)false);
    @Option(help="Instrument Truffle boundaries and output profiling information to the standard output.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InstrumentBoundaries = new OptionKey((Object)false);
    @Option(help="Instrument Truffle boundaries by considering different inlining sites as different branches.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InstrumentBoundariesPerInlineSite = new OptionKey((Object)false);
    @Option(help="Instrument branches and output profiling information to the standard output.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InstrumentBranches = new OptionKey((Object)false);
    @Option(help="Instrument branches by considering different inlining sites as different branches.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> InstrumentBranchesPerInlineSite = new OptionKey((Object)false);
    @Option(help="Maximum number of entries in the encoded graph cache (< 0 unbounded, 0 disabled).", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> EncodedGraphCacheCapacity = new OptionKey((Object)0);
    @Option(help="Delay, in milliseconds, after which the encoded graph cache is dropped when the compile queue becomes idle.The option is only supported on the HotSpot (non-libgraal) Truffle runtime.On runtimes which doesn't support it the option has no effect.", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> EncodedGraphCachePurgeDelay = new OptionKey((Object)10000);
    @Option(help="Forces the frame clearing mechanism to be executed, even if Frame.clear() is not used.", category=OptionCategory.EXPERT)
    public static final OptionKey<Boolean> ForceFrameLivenessAnalysis = new OptionKey((Object)false);
    @Option(help="Use the priority of compilation jobs in the compilation queue.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> PriorityQueue = new OptionKey((Object)true);
    @Option(help="Use a traversing compilation queue.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraversingCompilationQueue = new OptionKey((Object)false);
    @Option(help="Traversing queue uses rate as priority for both tier.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraversingQueueWeightingBothTiers = new OptionKey((Object)true);
    @Option(help="Traversing queue gives first tier compilations priority.", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraversingQueueFirstTierPriority = new OptionKey((Object)true);
    @Option(help="Print detailed information for inlining (i.e. the entire explored call tree).", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> TraceInliningDetails = new OptionKey((Object)false);
    @Option(help="Explicitly pick a inlining policy by name. If empty (default) the highest priority chosen by default.", category=OptionCategory.INTERNAL)
    public static final OptionKey<String> InliningPolicy = new OptionKey((Object)"");
    @Option(help="The base expansion budget for language-agnostic inlining.", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> InliningExpansionBudget = new OptionKey((Object)12000);
    @Option(help="The base inlining budget for language-agnostic inlining", category=OptionCategory.EXPERT)
    public static final OptionKey<Integer> InliningInliningBudget = new OptionKey((Object)12000);

    public static OptionDescriptors getDescriptors() {
        return new PolyglotCompilerOptionsOptionDescriptors();
    }

    public static enum ExceptionAction {
        Silent,
        Print,
        Throw,
        Diagnose,
        ExitVM;

        private static final String HELP = "Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.";
    }

    public static enum CompilationTier {
        peTier,
        truffleTier,
        lowTier;


        static CompilationTier parse(String name) {
            try {
                return CompilationTier.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Unknown tier option value '%s'. %s", name, PolyglotCompilerOptions.EXPANSION_VALUES));
            }
        }
    }

    public static enum PerformanceWarningKind {
        VIRTUAL_RUNTIME_CALL("call", "Enables virtual call warnings"),
        VIRTUAL_INSTANCEOF("instanceof", "Enables virtual instanceof warnings"),
        VIRTUAL_STORE("store", "Enables virtual store warnings"),
        FRAME_CLEAR_PHI("clear", "Enables frame clears introducing phi nodes warnings"),
        TRIVIAL_FAIL("trivial", "Enables trivial fail warnings");

        private static final EconomicMap<String, PerformanceWarningKind> kindByName;
        final String name;
        final String help;

        private PerformanceWarningKind(String name, String help) {
            this.name = name;
            this.help = help;
        }

        public static PerformanceWarningKind forName(String name) {
            PerformanceWarningKind kind = (PerformanceWarningKind)((Object)kindByName.get((Object)name));
            if (kind == null) {
                throw new IllegalArgumentException("Unknown PerformanceWarningKind name " + name);
            }
            return kind;
        }

        static {
            kindByName = EconomicMap.create();
            for (PerformanceWarningKind kind : PerformanceWarningKind.values()) {
                kindByName.put((Object)kind.name, (Object)kind);
            }
        }
    }

    public static enum EngineModeEnum {
        DEFAULT,
        THROUGHPUT,
        LATENCY;

    }
}

