/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.substitutions;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;

public class TruffleDecodingPlugins {
    public static void registerInvocationPlugins(InvocationPlugins plugins, Providers providers) {
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        TruffleDecodingPlugins.registerGraalCompilerDirectivesPlugins(plugins, metaAccess);
    }

    private static void registerGraalCompilerDirectivesPlugins(InvocationPlugins plugins, MetaAccessProvider metaAccess) {
        ResolvedJavaType graalCompilerDirectivesType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "org.graalvm.compiler.truffle.runtime.GraalCompilerDirectives");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(graalCompilerDirectivesType));
        r.setAllowOverwrite(true);
        r.register0("inFirstTier", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (b.getGraph().getCancellable() instanceof TruffleCompilationTask) {
                    boolean isFirstTier = ((TruffleCompilationTask)((Object)b.getGraph().getCancellable())).isFirstTier();
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(isFirstTier));
                    return true;
                }
                return false;
            }
        });
    }
}

